/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersDropDownMenu.java,v 1.6 2008/01/24 02:29:01 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;


public class FiltersDropDownMenu implements IMenuCreator {

	/**
	 * Cascading menu 
	 */
	protected Menu _menu;
	protected FiltersEditorAction _feAction;
	protected FilterInformationManager _fi;
	
	public FiltersDropDownMenu(FilterInformationManager fi)
	{
		super();

		_fi = fi;		
		_feAction = new FiltersEditorAction(_fi);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#dispose()
	 */
	public void dispose() {
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#getMenu(org.eclipse.swt.widgets.Control)
	 */
	public Menu getMenu(Control parent) {
		if (_menu != null) {
			_menu.dispose();
		}
		_menu = new Menu(parent);
		
		final String NO_FILTER_NAME = CommonUIMessages._111;
		String selectedFilterName = _fi.selectedFilterName();
		boolean noFilterSelected = true;
		boolean actionNoFilterFound = false;
		for (int i = 0; i < _fi.size(); i++) {
			String filterName = _fi.filter(i).name();
			if (!actionNoFilterFound && NO_FILTER_NAME.equals(filterName)) {
				actionNoFilterFound = true;
				continue;
			}
			ImageDescriptor icon = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(_fi.filter(i).type()).icon();
			FiltersSetAction action = new FiltersSetAction(this, filterName, icon);
			
			if (selectedFilterName != null
					&& selectedFilterName.equals(action.getText())) {
				action.setChecked(true);
				noFilterSelected = false;				
			} else {
				action.setChecked(false);
			}
			addActionToMenu(_menu, action);
		}

		// adding "No Filter" as the last item in the menu
		// if stored and default selections are somehow broken 
		// here we also provide "No Filter" selected by default
		if (actionNoFilterFound || noFilterSelected) {
			FiltersSetAction action = new FiltersSetAction(this, NO_FILTER_NAME, null);
			addActionToMenu(_menu, action);
			if (noFilterSelected) {
				action.setChecked(true);
				_fi.selectedFilterName(NO_FILTER_NAME, false);
			}
		}
		
		new Separator().fill(_menu, -1);
		addActionToMenu(_menu, _feAction);		
		
		return _menu;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#getMenu(org.eclipse.swt.widgets.Menu)
	 */
	public Menu getMenu(Menu parent) {
		return null;
	}
	
	protected void addActionToMenu(Menu parent, Action action) {
		ActionContributionItem item= new ActionContributionItem(action);
		item.fill(parent, -1);
	}	
	
	public void selectedFilterName(String filterName)
	{
		_fi.selectedFilterName(filterName);
	}	
}
