/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersEditorAction.java,v 1.4 2008/03/20 14:29:38 ialelekov Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersEditDialog;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;


public class FiltersEditorAction extends Action {
	
	protected FilterInformationManager _fi;
	private boolean showNoFilter = false;
	
	public FiltersEditorAction(FilterInformationManager fi) {
		this(fi, false);
	}
	
	public FiltersEditorAction(FilterInformationManager fi, boolean showNoFilter) {
		super("");

		_fi = fi;
		this.showNoFilter = showNoFilter;
		
		setText(CommonUIMessages._109);
		CommonUIImages.INSTANCE.setImageDescriptors(this, CommonUIImages.IMG_UI_VIEW_FILTER);
		
		setEnabled(true);
	}
	
	public void run() {
		FiltersEditDialog filtersEditDlg = FilterUIUtil.getFiltersEditDialog(_fi, showNoFilter);
		filtersEditDlg.selectedFilterName(_fi.selectedFilterName());
		filtersEditDlg.open();
		
		if (filtersEditDlg.getReturnCode() == FiltersEditDialog.OK)
		{
			//if (filtersEditDlg.selectedFilterName() != null)
			_fi.selectedFilterName(filtersEditDlg.selectedFilterName());
			// different events will be displayed in the log view, so send this event to invoke highlighting update
			CommonUIPlugin.getDefault().getPreferenceStore().firePropertyChangeEvent("filters.highlightings.ok", null, null);
		}
	}
	
	public void run(IAction action) {
		run();
	}
	
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}
	
	public void init(IViewPart view) {
	}

}
