/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersSelectionAction.java,v 1.3 2008/01/24 02:29:01 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;


public class FiltersSelectionAction extends Action {

	protected FiltersDropDownMenu _fddm;
	protected FilterInformationManager _fi;
	
	public FiltersSelectionAction(FilterInformationManager fi) {
		super("");

		_fi = fi;
		_fddm = new FiltersDropDownMenu(_fi);
		setMenuCreator(_fddm);
		
		CommonUIImages.INSTANCE.setImageDescriptors(this, CommonUIImages.IMG_UI_VIEW_FILTER);
		
		setToolTipText(CommonUIMessages._109);
		setDescription(CommonUIMessages._109);
		setEnabled(true);		
	}
	
	
	public void run() {
		CreateOrEditFilter.run(_fi, 0, null, null, -1);
	}
	
	
	
	public void run(IAction action) {
		run();
	}
	
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}
	
	public void init(IViewPart view) {
	}
}	

