/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersSetAction.java,v 1.5 2008/01/24 02:29:01 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class FiltersSetAction extends Action {
	
	protected FiltersDropDownMenu _menu;
	protected String _filterName;
	
	/**
	 * 
	 */
	public FiltersSetAction(FiltersDropDownMenu menu, String filterName, ImageDescriptor imageDescriptor) {
		super(filterName, IAction.AS_RADIO_BUTTON);
		_menu = menu;
		_filterName = filterName;
		
		if (imageDescriptor != null)
			setImageDescriptor(imageDescriptor);
		
		//setText(_filterName);
	}
	
	public void run() {
		if (isChecked()){		
			_menu.selectedFilterName(_filterName);
			// different events will be displayed in the log view, so send this event to invoke highlighting update
			CommonUIPlugin.getDefault().getPreferenceStore().firePropertyChangeEvent("filters.highlightings.ok", null, null);
		}
	}
	
	public void run(IAction action) {
		run();
	}
	
}
