/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterElement.java,v 1.3 2008/01/24 02:28:49 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.filters.IFilterAttribute;


public class FilterElement {
	protected IFilterAttribute _attribute;
	protected String _operator;
	protected String _value;
	
	public FilterElement(IFilterAttribute attribute, String operator, String value)
	{
		_attribute = attribute;
		_operator = operator;
		_value = value;
	}
	
	public IFilterAttribute attribute()
	{
		return _attribute;
	}
	
	public String operator()
	{
		return _operator;
	}
	
	public String value()
	{
		return _value;
	}
	
	public void setAttribute(IFilterAttribute attribute)
	{
		_attribute = attribute;
	}
	
	public void setOperator(String operator)
	{
		_operator = operator;
	}
	
	public void setValue(String value)
	{
		_value = value;
	}	
}
