/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterElementSet.java,v 1.3 2008/01/24 02:28:49 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.dialogs;

import java.util.Vector;


public class FilterElementSet {
	protected Vector _filterElements;
	
	public FilterElementSet()
	{
		_filterElements = new Vector();
	}

	public void addFilterElement(FilterElement fe)
	{
		_filterElements.addElement(fe);
	}
	
	public FilterElement filterElement(int i)
	{
		return (FilterElement)_filterElements.elementAt(i);
	}
	
	public int size()
	{
		return _filterElements.size();
	}
	
	public void removeFilterElement(FilterElement fe)
	{
		_filterElements.remove(fe);
	}

	public Object[] toArray()
	{
		return _filterElements.toArray();
	}
}
