/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterTypeDialog.java,v 1.5 2008/01/24 02:28:49 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FilterTypeDialog extends Dialog {

	
	public class FilterTypeLabelProvider extends LabelProvider
	{
		public String getText(Object element)
		{
			return ((IFilterType)element).name();
		}
		
		public Image getImage(Object element) {
			ImageDescriptor icon = ((IFilterType)element).icon(); 
			if (icon != null)
				return icon.createImage();
			else
				return null;
		}		
		
		public void dispose() {
		}
		
	}
	
	public class FilterTypeContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if (_fi != null && _fi == inputElement) {
				return _fi.getFilterTypes();
			}
			return new Object[0];			
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}	
	
	protected TableViewer _typeListViewer;	
	
	protected FilterInformationManager _fi;
	
	protected IFilterType _selectedFilterType;
	
	
	protected FilterTypeDialog(FilterInformationManager fi) {
		super(Display.getDefault().getActiveShell());
		
		_fi = fi;
	}
	
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(CommonUIMessages._79);
		
		Composite composite = (Composite) super.createDialogArea(parent);

		createMessageLabel(composite);
		
		Composite listComposite = new Composite(composite, SWT.NULL);
		GridLayout layout;
		layout = new GridLayout();
		layout.numColumns = 2;
		listComposite.setLayout(layout);		
		
		_typeListViewer = new TableViewer(listComposite, SWT.BORDER | SWT.MULTI);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		data.grabExcessHorizontalSpace = true;
		data.heightHint = 200;
		data.widthHint = 200;
		_typeListViewer.getTable().setLayoutData(data);		
		_typeListViewer.getTable().addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
			}
		});		
		
		_typeListViewer.setLabelProvider(new FilterTypeLabelProvider());
		_typeListViewer.setContentProvider(new FilterTypeContentProvider());
		_typeListViewer.setSorter(new WorkbenchViewerSorter());
		_typeListViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				//handleSelectionChanged();
			}
		});
		_typeListViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				//edit action?
			}
		});
		
		_typeListViewer.setInput(_fi);
		_typeListViewer.setSorter(null);
		_typeListViewer.refresh();
		
		setInitialSelection();
		
       PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, "org.eclipse.hyades.ui.mgrproftr");

		return composite;
	}
	
	protected Label createMessageLabel(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText(CommonUIMessages._117);
		return label;
	}
	
	protected void selectTableItem(Table table, int selection) {
		table.setFocus();
		table.setSelection(selection);
		table.showSelection();
	}		
	
	protected void setInitialSelection()
	{
		selectTableItem(_typeListViewer.getTable(), 0);		
	}

	protected void okPressed() {
		int selection = _typeListViewer.getTable().getSelectionIndex();
		
		super.okPressed();
		
		_selectedFilterType = _fi.getFilterTypes()[selection];
	}
	
	protected void cancelPressed()
	{
		super.cancelPressed();
		
		_selectedFilterType = null;
	}
	
	public IFilterType selectedFilterType()
	{
		return _selectedFilterType;
	}
}
