/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersAdvancedUI.java,v 1.6 2008/03/11 03:56:49 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;

public class FiltersAdvancedUI extends FiltersTabUI {

	//private static String OR_SEPARATOR = "|";
	
	public class FilterSetLabelProvider extends LabelProvider implements ITableLabelProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {
			FilterElement fe = (FilterElement)element;
			
			if (columnIndex == 0)
				return fe.attribute().displayText();
			else if (columnIndex == 1)
				return fe.operator();
			else if (columnIndex == 2)
				return fe.value();
			
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose() {
		}
	}
	
	public class FilterSetContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if (_filterElementSet != null) {
				return _filterElementSet.toArray();
			}
			return new Object[0];		

		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}	
	

	class EditDialog extends Dialog{
		protected IFilterAttribute _attribute;
		protected String _operator;
		protected String _value;
		protected Combo _AttributeText;
		protected Combo _OperatorText;
		protected Text _ValueText;
		protected String _title;

		public EditDialog(
			Shell shell,
			String title,
			IFilterAttribute attribute,
			String operator,
			String value) {
			super(shell);

			_attribute = attribute;
			_operator = operator;
			_value = value;
			_title = title;
		}

		protected void configureShell(Shell shell) {
			super.configureShell(shell);
			shell.setText(_title);
		}

		public IFilterAttribute attribute() {
			return _attribute;
		}

		public String operator() {
			return _operator;
		}

		public String value() {
			return _value;
		}
		
		protected void attributeUpdate(IFilterAttribute attribute)
		{
			_ValueText.setText(attribute.defaultValue());
			
			_OperatorText.removeAll();
			String [] operators = attribute.operators();
			for (int i=0;i<operators.length;i++)
			{
				_OperatorText.add(operators[i]);	
			}			
			
			_OperatorText.select(0);			
		}

		protected Control createDialogArea(Composite parent) {
			Composite result = (Composite) super.createDialogArea(parent);
			
			/* Navid Mehregani - bugzilla: Set context help for advanced filtering page */
			PlatformUI.getWorkbench().getHelpSystem().setHelp(result, "org.eclipse.hyades.ui.mgrproftr");
		

			GridLayout layout;
			GridData data;
			Label label;

			layout = new GridLayout();
			layout.numColumns = 2;
			result.setLayout(layout);
			data = GridUtil.createFill();
			data.widthHint = 400;
			result.setLayoutData(data);

			label = new Label(result, SWT.NULL);
			label.setText(CommonUIMessages._82);
			_AttributeText = new Combo(result, SWT.BORDER | SWT.READ_ONLY);
			_AttributeText.setLayoutData(GridUtil.createHorizontalFill());
			_AttributeText.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					attributeUpdate(getAttributeFromString(_AttributeText.getText().trim()));
				}
			});
			
			for (int i=0;i<_attributes.length;i++)
			{
				_AttributeText.add(_attributes[i].displayText());	
			}
			
			label = new Label(result, SWT.NULL);
			label.setText(CommonUIMessages._83);
			_OperatorText = new Combo(result, SWT.BORDER | SWT.READ_ONLY);
			_OperatorText.setLayoutData(GridUtil.createHorizontalFill());

			label = new Label(result, SWT.NULL);
			label.setText(CommonUIMessages._84);
			_ValueText = new Text(result, SWT.BORDER);
			_ValueText.setLayoutData(GridUtil.createHorizontalFill());

			_AttributeText.select(0);
			//_OperatorText.select(0);

			if (_attribute != null)
				_AttributeText.setText(_attribute.displayText());
			
			attributeUpdate(getAttributeFromString(_AttributeText.getText().trim()));

			if (_operator != null)
				_OperatorText.setText(_operator);
			
			if (_value != null)
				_ValueText.setText(_value);			

			_AttributeText.setFocus();
			setContextHelpId(result);

			return result;
		}


		protected void okPressed() {
			_attribute = getAttributeFromString(_AttributeText.getText().trim());
			_operator = _OperatorText.getText();
			_value = _ValueText.getText();
			super.okPressed();
		}
		
		protected void setContextHelpId(Control control){
			/*switch(iType){
				case LogUIConstants.FILTER_LOG_VIEW:
				{
			
					WorkbenchHelp.setHelp(control, ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
					break;
				}
				case LogUIConstants.FILTER_LOG_INTER:
				{
					WorkbenchHelp.setHelp(control, ContextIds.LOGINTER_VIEW_DIALOG_FILTER);
					break;
				}
				case LogUIConstants.SEARCH:
				{
					WorkbenchHelp.setHelp(control, ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);						
				}
			
			}*/
		}
		
	}

	protected Table _table; 
	
	//protected Button _upBtn;
	//protected Button _downBtn;
	protected Button _addBtn;
	protected Button _editBtn;
	protected Button _removeBtn;
	protected Combo _groupCombo;
	
	protected Composite result;
	protected CheckboxTableViewer _tableViewer;

	public static IFilterAttribute[] _attributes;
	
	protected FilterElementSet _filterElementSet;
	
	protected Link _link;
	
	protected Label _contentLabel;
	
	public FiltersAdvancedUI(IAdvancedTabAttributeSet attributes)
	{
		_attributes = attributes.getAttributes();
	}
	
	public Control createControl(Composite parent) {
		GridData data;
		GridLayout layout;
	
		result = new Composite(parent, SWT.NULL);
			
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 0;
		result.setLayout(layout);
		data = GridUtil.createFill();
		//data = new GridData();
		result.setLayoutData(data);
			
		createContentDescription(result);
	
		Composite tableGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		tableGroup.setLayout(layout);
		data = new GridData();
		data.heightHint = 250;
		data.widthHint = 400;
		//data = GridUtil.createFill();
		tableGroup.setLayoutData(data);
		initializeTable(tableGroup);
	
		Composite btnGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		btnGroup.setLayout(layout);
		btnGroup.setLayoutData(GridUtil.createVerticalFill());
	
		Composite addGroup = new Composite(btnGroup, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.makeColumnsEqualWidth = true;
		addGroup.setLayout(layout);
		addGroup.setLayoutData(GridUtil.createVerticalFill());
	
		_addBtn = createModifyButton(addGroup, CommonUIMessages._86, CommonUIMessages._87);
		_addBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				addButtonPressed();
			}
		});
		
		_editBtn = createModifyButton(addGroup, CommonUIMessages._88, CommonUIMessages._89);
		_editBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				editButtonPressed();
			}
		});
		
		_removeBtn = createModifyButton(addGroup, CommonUIMessages._90, CommonUIMessages._91);
		_removeBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				removeButtonPressed();
			}
		});
		
	
		Composite moveGroup = new Composite(btnGroup, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.makeColumnsEqualWidth = true;
		moveGroup.setLayout(layout);
		moveGroup.setLayoutData(GridUtil.createHorizontalFill());
		
		Composite detailGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		detailGroup.setLayout(layout);
		data = GridUtil.createFill();
		data.horizontalSpan = 2;
		detailGroup.setLayoutData(data);
		
		Label _groupingLabel = new Label(detailGroup, SWT.NULL);
		_groupingLabel.setText(CommonUIMessages._164);
		data = new GridData();
		_groupingLabel.setLayoutData(data);
		
		_groupCombo = new Combo(detailGroup,SWT.NULL);
		_groupCombo.add(CommonUIMessages._162);
		_groupCombo.add(CommonUIMessages._163);
		data = new GridData();
		_groupCombo.setLayoutData(data);		
		
		createLink(detailGroup);
		
		_editBtn.setEnabled(false);
		_removeBtn.setEnabled(false);
		_groupCombo.select(0);
		
		//_upBtn.setEnabled(false);
		//_downBtn.setEnabled(false);
		
		//setContextHelpIds();
		
		/* Navid Mehregani - bugzilla: Set context help for advanced filtering page */
		PlatformUI.getWorkbench().getHelpSystem().setHelp(result, "org.eclipse.hyades.ui.mgrproftr");
		
		return result;
	}
	
	protected void createContentDescription(Composite parent){
		_contentLabel = new Label(parent, SWT.NULL);
		_contentLabel.setText(CommonUIMessages._85);
		GridData data = new GridData();
		//data = GridUtil.createFill();		
		data.horizontalSpan = 2;
		_contentLabel.setLayoutData(data);				

	}
	
	protected void createLink(Composite parent){
		
		_link = new Link(parent, SWT.NONE);
		String text = CommonUIMessages._165;
		_link.setText(text);
		_link.addListener (SWT.Selection, new Listener () {
			public void handleEvent(Event event) {
				PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.tptp.platform.doc.user/tasks/tfiltering.htm"); 
			}
		});
		GridData data = GridUtil.createHorizontalFill();
		data.horizontalSpan=2;
		_link.setLayoutData(data);
		
	}
	
	protected Button createModifyButton(Composite parent, String text, String toolTipText)
	{
		Button button = new Button(parent, SWT.PUSH);
		button.setText(text);
		button.setToolTipText(toolTipText);
		button.setLayoutData(GridUtil.createHorizontalFill());
		
		return button;
	}	
	
	protected void initializeTable(Composite parent) {
		createTable(parent);
		_tableViewer = new CheckboxTableViewer(_table);
		createColumns();
	
		_tableViewer.setContentProvider(new FilterSetContentProvider());
		_tableViewer.setLabelProvider(new FilterSetLabelProvider());
	
		//_filterList = new FilterList(_tableViewer);
		_tableViewer.setInput(new Object());
	
	/*	CellEditor editors[] = new CellEditor[_table.getColumnCount()];
	
		editors[0] = new ComboBoxCellEditor(_table, _attributes);
		editors[1] = new ComboBoxCellEditor(_table, _operators);
		editors[2] = new TextCellEditor(_table);
	
		_tableViewer.setCellEditors(editors);
	
		FilterElementModifier modifier = new FilterElementModifier(_tableViewer);
		_tableViewer.setCellModifier(modifier);
		_tableViewer.setColumnProperties(tableColumnProperties);
		*/

	}

	protected void createTable(Composite parent) {
		_table = new Table(
						parent,
						SWT.H_SCROLL
						| SWT.V_SCROLL
						| SWT.BORDER
						| SWT.MULTI
						| SWT.FULL_SELECTION);
		_table.setLinesVisible(true);
		_table.setLayoutData(GridUtil.createFill());
		
		_table.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				tableSelect();
			}
		});
	}
	
	protected void createColumns() {
		TableLayout layout = new TableLayout();
		_table.setLayout(layout);
		_table.setHeaderVisible(true);
	
		String headers[] =
			{	CommonUIMessages._82,
				CommonUIMessages._83,
				CommonUIMessages._84};
		ColumnLayoutData layouts[] =
			{	new ColumnPixelData(120, true),
				new ColumnPixelData(70, true),
				new ColumnPixelData(130, true)};
	
		final TableColumn columns[] = new TableColumn[headers.length];
		
		for (int i = 0; i < headers.length; i++) {
			layout.addColumnData(layouts[i]);
			TableColumn tc = new TableColumn(_table, SWT.NONE, i);
			tc.setResizable(layouts[i].resizable);
			tc.setText(headers[i]);
			columns[i] = tc;
		}
	}

	public boolean storeValues(IPreferenceStore store,String preferenceProperty) {
	//	return FilterTableElement.saveFilters(_filterList.getFilters(),preferenceProperty,store);
		return true;
	}
	
	public boolean storeValues(IPreferenceStore store) {
		//return FilterTableElement.saveFilters(_filterList.getFilters(),LogUIConstants.PD_ADV_FILTER_OPTIONS,store);
		return true;
	}
	
	public Composite getControl() {
		return result;
	}
	
	protected void enableButtons() {
		int selection = _table.getSelectionIndex();
		int selectionCount = _table.getSelectionCount();
	
		_removeBtn.setEnabled(getTableLength() > 0 && selection != -1);
		_editBtn.setEnabled(getTableLength() > 0 && selection != -1 && selectionCount == 1);
	
/*		_upBtn.setEnabled(selection > 0 && selectionCount == 1);
		_downBtn.setEnabled(selection >= 0
				&& selection < _table.getItemCount() - 1
				&& selectionCount == 1);
*/
	}
	
	protected void selectTableItem(Table table, int selection) {
		table.setFocus();
		table.setSelection(selection);
		table.showSelection();
	}
	
	protected void showEditDialog(String title, FilterElement fe) {
	
		EditDialog dialog;
		
		if (fe != null)
			dialog = new EditDialog(result.getShell(), title, fe.attribute(), fe.operator(), fe.value());
		else
			dialog = new EditDialog(result.getShell(), title, null, null, null);
			
		dialog.open();
	
		if (dialog.getReturnCode() == Window.OK) {
			
			if (fe != null)
			{
				fe.setAttribute(dialog.attribute());
				fe.setOperator(dialog.operator());
				fe.setValue(dialog.value());
				_tableViewer.refresh();				
			}
			else
			{
				_filterElementSet.addFilterElement(new FilterElement(dialog.attribute(), dialog.operator(), dialog.value()));
				_tableViewer.refresh();		
				selectTableItem(_table, getTableLength() - 1);
			}
		}
		
		validateValues();
	}
	
	protected void validateValues()
	{
		for (int i = 0; i < _filterElementSet.size(); i++)
		{
			FilterElement fe = _filterElementSet.filterElement(i);
			String errorMsg = fe.attribute().validate(fe.operator(), fe.value());
			if (errorMsg != null)
			{
				setError(errorMsg);
				return;
			}
		}
		
		noError();
	}
	
	protected void addButtonPressed()
	{
		showEditDialog(
				CommonUIMessages._101,
				null);
			enableButtons();
	}
	
	protected void editButtonPressed()
	{
		int idx = _table.getSelectionIndex();
		if (idx != -1) {
			
			FilterElement fe = getFilterElement(idx);
			
			showEditDialog(
				CommonUIMessages._102,
				fe);
		}
	}	

	
	protected void removeButtonPressed()
	{
		 int selection = _table.getSelectionIndex();
		
		 int indices[] = _table.getSelectionIndices();

		 if (indices.length > 0) {
			 FilterElement[] removingFilters = new FilterElement[indices.length];
			 for (int i = 0; i < indices.length; i++) {
				 removingFilters[i] = _filterElementSet.filterElement(indices[i]);
			 }
			 for (int i = 0; i < indices.length; i++) {
				 _filterElementSet.removeFilterElement(removingFilters[i]);
			 }
		 }
		
		_tableViewer.refresh();
		
		int size = getTableLength();
		
		if (size > 0) {
			int newSelectionIndex = (0 < selection && selection < size) ? selection - 1 : 0;  
			selectTableItem(_table, newSelectionIndex);
		}
		enableButtons();
		
		validateValues();
	}		
	
/*	protected void upButtonPressed()
	{
		_tableViewer.refresh();
		
				int selection = _table.getSelectionIndex();
				if (selection > 0) {
					FilterTableElement sel =
						(FilterTableElement) _filterList.getElementAt(selection);
					FilterTableElement previous =
						(FilterTableElement) _filterList.getElementAt(
							selection - 1);
		
					String attribute = sel.getAttribute();
					String operator = sel.getOperator();
					String value = sel.getValue();
		
					sel.setAttribute(previous.getAttribute());
					sel.setOperator(previous.getOperator());
					sel.setValue(previous.getValue());
					
					previous.setAttribute(attribute);
					previous.setOperator(operator);
					previous.setValue(value);
			
					selectTableItem(_table, selection - 1);
				}
			_tableViewer.refresh();
			enableButtons();
					

	}*/		
	
/*	protected void downButtonPressed()
	{
		_tableViewer.refresh();
		
				int selection = _table.getSelectionIndex();
				if (selection < _table.getItemCount() - 1) {
					FilterTableElement sel =
						(FilterTableElement) _filterList.getElementAt(selection);
					FilterTableElement next =
						(FilterTableElement) _filterList.getElementAt(
							selection + 1);
		
					String attribute = sel.getAttribute();
					String operator = sel.getOperator();
					String value = sel.getValue();
		
					sel.setAttribute(next.getAttribute());
					sel.setOperator(next.getOperator());
					sel.setValue(next.getValue());
		
					next.setAttribute(attribute);
					next.setOperator(operator);
					next.setValue(value);
		
					selectTableItem(_table, selection + 1);
				}
		
				_tableViewer.refresh();
				enableButtons();
	}*/		

	protected void tableSelect()
	{
		enableButtons();
	}
	
	public String getTabName()
	{
		return CommonUIMessages._81;
	}
	
	public Image getTabImage()
	{
		return CommonUIImages.INSTANCE.getImage(CommonUIImages.IMG_UI_VIEW_FILTER_OBJ);
	}
	
	protected FilterElement getFilterElement(int idx)
	{
		return (FilterElement)_tableViewer.getElementAt(idx);// ((IStructuredContentProvider)_tableViewer.getContentProvider()).getElements(getFilterSet())[idx];		
	}
	
	protected int getTableLength()
	{
		return _filterElementSet.size();
	}
	
	protected IFilterAttribute getAttributeFromString(String attributeStr)
	{
		for (int i = 0; i < _attributes.length; i++)
		{
			if (_attributes[i].displayText().equals(attributeStr))
				return _attributes[i];
		}
		return null;
	}
	
	protected IFilterAttribute getAttributeFromID(String id)
	{
		for (int i = 0; i < _attributes.length; i++)
		{
			if (_attributes[i].id().equals(id))
				return _attributes[i];
		}
		return null;
	}	

	public void initializeFrom(SimpleSearchQuery filter) {
		FilterElementSet filterElementSet = new FilterElementSet();
		
		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			 LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
		
			 _groupCombo.select(logicalExpression.getOperator()==LogicalOperators.AND_LITERAL?0:1);
			 
			 EList filterElements = logicalExpression.getArguments();
			 for (int i = 0; i < filterElements.size(); i++)
			 {
			 	WhereExpression whereExpression = (WhereExpression)filterElements.get(i);
			 	String whereExpressionName = whereExpression.getName();
			 	int idx = whereExpressionName.indexOf(":");
			 	if (idx >= 0)
			 	{
				 	IFilterAttribute filterAttribute = getAttributeFromID(whereExpressionName.substring(idx+1));
				 	
				 	if (filterAttribute != null)
				 	{
				 		String feOperator = filterAttribute.getOperator(whereExpression);
				 		String feValue = filterAttribute.getValue(whereExpression);
				 		
				 		if (feOperator != null && feValue != null)
					 		filterElementSet.addFilterElement(new FilterElement(filterAttribute, feOperator, feValue));
				 	}
			 	}
			 }
		}
		
		_filterElementSet = filterElementSet;
		
		_tableViewer.refresh();		
	}
	
	public SimpleSearchQuery performApply() {
		SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
		LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		logicalExpression.setOperator(_groupCombo.getSelectionIndex()==0?LogicalOperators.AND_LITERAL:LogicalOperators.OR_LITERAL);
		EList arguments = logicalExpression.getArguments();
		
		for (int i = 0; i < _filterElementSet.size(); i++)
		{
			FilterElement fe = _filterElementSet.filterElement(i);

			WhereExpression whereExpression = fe.attribute().getWhereExpression(fe.operator(), fe.value());
			
			if (whereExpression != null)
			{
				whereExpression.setName(getWhereExpressionName(logicalExpression, fe.attribute()));
				arguments.add(whereExpression);
			}
		}
		
		filter.setWhereExpression(logicalExpression);		
		return filter;
	}
	
	protected void selectItem(int item)
	{
		if (item >= 0 && item < _table.getItemCount())
			selectTableItem(_table, item);		
	}
	
	public static String getWhereExpressionName(LogicalExpression advancedLogicalExpression, IFilterAttribute filterAttribute)
	{
		return "AD" + advancedLogicalExpression.getArguments().size() + ":" + filterAttribute.id();
	}
}
