/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersEditDialog.java,v 1.8 2008/03/20 14:29:37 ialelekov Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class FiltersEditDialog extends Dialog {

	protected TableViewer _filtersListViewer;
	protected FilterInformationManager _fi;
	
	protected Button _newButton;
	protected Button _removeButton;
	protected Button _editButton;
	
//	private Button _moveUpButton;
//	private Button _moveDownButton;
	
	protected String _selectedFilterName = null;
	protected FilterQueries noFilter = null;
	private boolean showNoFilter = false;
	
	public class FilterSetLabelProvider extends LabelProvider
	{

		public String getText(Object element) {
			return ((FilterQueries)element).name();
		}
		
		public Image getImage(Object element) {
			ImageDescriptor icon = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(((FilterQueries)element).type()).icon();
			if (icon != null)
				return icon.createImage();
			else
				return null;
		}		
		
		
		public void dispose() {
		}
		
	}
	
	public class FilterSetContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if (_fi != null && _fi == inputElement) {
				return _fi.getFiltersArray();
			}
			return new Object[0];			
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}	

	protected FiltersEditDialog(FilterInformationManager fi) {
		this(fi, false);
	}
	
	protected FiltersEditDialog(FilterInformationManager fi, boolean showNoFilter) {
		super(Display.getDefault().getActiveShell());
		
		_fi = fi;
		this.showNoFilter = showNoFilter;
	}
	
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(CommonUIMessages._79);
		
		Composite composite = (Composite) super.createDialogArea(parent);

		createMessageLabel(composite);
		
		Composite listComposite = new Composite(composite, SWT.NULL);
		GridLayout layout;
		layout = new GridLayout();
		layout.numColumns = 1;
		listComposite.setLayout(layout);		
		
		_filtersListViewer = new TableViewer(listComposite, SWT.BORDER | SWT.MULTI);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		data.grabExcessHorizontalSpace = true;
		data.heightHint = 200;
		data.widthHint = 200;
		_filtersListViewer.getTable().setLayoutData(data);		
		_filtersListViewer.getTable().addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				tableSelect();
			}
		});		
		
		_filtersListViewer.setLabelProvider(new FilterSetLabelProvider());
		_filtersListViewer.setContentProvider(new FilterSetContentProvider());
		_filtersListViewer.setComparator(new WorkbenchViewerComparator());
		_filtersListViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				//handleSelectionChanged();
			}
		});
		_filtersListViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				//edit action?
			}
		});
		
//		createMoveButtonsControl(listComposite);
		
		if (!showNoFilter) removeNoFilters();
		createButtonsControl(composite);
		_filtersListViewer.setInput(_fi);
		_filtersListViewer.setSorter(null);
		_filtersListViewer.refresh();
		setInitialSelection();
		enableButtons();		
		
        PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, "org.eclipse.hyades.ui.mgrproftr");

		return composite;
	}
	
	protected Label createMessageLabel(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText(CommonUIMessages._103);
		return label;
	}	
	
//	private Control createMoveButtonsControl(Composite composite) {
//		Composite buttonComposite = new Composite(composite, SWT.NULL);
//		GridLayout layout = new GridLayout();
//		layout.numColumns = 1;
//		buttonComposite.setLayout(layout);
//		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.CENTER);
//		data.grabExcessHorizontalSpace = true;		
//		buttonComposite.setLayoutData(data);
//
//		_moveUpButton = createModifyButton(buttonComposite, CommonUIMessages.getString("_107")); //$NON-NLS-1$
//		_moveUpButton.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				moveUpFilterSet();
//			}
//		});
//
//		_moveDownButton = createModifyButton(buttonComposite, CommonUIMessages.getString("_108")); //$NON-NLS-1$
//		_moveDownButton.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				moveDownFilterSet();
//			}
//		});
//		
//		_moveUpButton.setEnabled(true);
//		_moveDownButton.setEnabled(true);		
//
//		return buttonComposite;
//		
//	}

	protected Control createButtonsControl(Composite composite) {
		Composite buttonComposite = new Composite(composite, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		layout.makeColumnsEqualWidth = true;
		buttonComposite.setLayout(layout);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.CENTER);
		data.grabExcessHorizontalSpace = true;		
		buttonComposite.setLayoutData(data);

		_newButton = createModifyButton(buttonComposite, CommonUIMessages._104); 
		_newButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				createFilterSet();
			}
		});

		_editButton = createModifyButton(buttonComposite, CommonUIMessages._105); 
		_editButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				editFilterSet();
			}
		});

		_removeButton = createModifyButton(buttonComposite, CommonUIMessages._106); 
		_removeButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				removeFilterSets();
			}
		});
		
		_newButton.setEnabled(true);

		return buttonComposite;
	}
	
	protected Button createModifyButton(Composite parent, String text)
	{
		Button button = new Button(parent, SWT.PUSH);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		button.setLayoutData(data);
		button.setText(text);
		return button;
	}
	
	protected void createFilterSet()
	{
	// added for defect_155694 in order to eliminate the
	// select Log Type dialog when there is only one possible
	// Log Type. This checks to see if there is more than one
	// and then proceeds as before. Otherwise, it skips right to the
	// Log creation/editing dialog.
	// Liz Dancy
		
		String type;
		
		if (_fi.getFilterTypes().length > 1)
		{
			FilterTypeDialog filterTypeDialog  = FilterUIUtil.getFiltersTypeDialog(_fi);
			filterTypeDialog.open();
			IFilterType filterType = filterTypeDialog.selectedFilterType();
			type = filterType.id();
		}
		
		else
		{
			type = _fi.getFilterTypes()[0].id();
		}
	
		FilterQueries fq = _fi.createFilterQueries(type);
		FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(fq, _fi, 0);
		
		
		if (type == null)
			return;
		
		
		filtersDialog.open();
		
		if (filtersDialog.getReturnCode() == FiltersDialog.OK)
		{
			_fi.addFilter(fq);

			_filtersListViewer.refresh();
			setSelectedFilter(fq.name());		
			enableButtons();
		}
	}
	
	protected void editFilterSet()
	{
		int idx = _filtersListViewer.getTable().getSelectionIndex();
		if (idx != -1) {
			FilterQueries sel =
				(FilterQueries) _fi.filter(idx);
		
			FilterQueries copy = sel.copy();
			FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(copy, _fi, 0);
			filtersDialog.open();
			
			if (filtersDialog.getReturnCode() == FiltersDialog.OK)
			{
				_fi.removeFilter(sel);
				_fi.addFilter(copy);			
				_filtersListViewer.refresh();
				
				setSelectedFilter(copy.name());
			}
		}
	}	
	
	protected void removeFilterSets()
	{
		int selection = _filtersListViewer.getTable().getSelectionIndex();
			
		 _fi.removeFilters(_filtersListViewer.getTable().getSelectionIndices());
			
		 _filtersListViewer.refresh();
			
		 int size = _fi.size();
		 if (size > 0) {
		 	if (selection > 0 && selection < size) {
		 		selectTableItem(_filtersListViewer.getTable(), selection - 1);
			} else {
				selectTableItem(_filtersListViewer.getTable(), 0);
			}
		 }
		
		 enableButtons();		
	}
	
//	private void moveUpFilterSet()
//	{
//		int idx = _filtersListViewer.getTable().getSelectionIndex();
//		if (idx > 0 && idx < _fi.size()) {
//			_fi.moveUp(idx);
//			
//			_filtersListViewer.refresh();
//			selectTableItem(_filtersListViewer.getTable(), idx-1);
//			enableButtons();
//		}
//		
//	}
	
//	private void moveDownFilterSet()
//	{
//		
//		int idx = _filtersListViewer.getTable().getSelectionIndex();
//		if (idx >= 0 && idx < (_fi.size() - 1)) {
//			_fi.moveDown(idx);
//			
//			_filtersListViewer.refresh();		
//			selectTableItem(_filtersListViewer.getTable(), idx+1);
//			enableButtons();			
//		}
//	}
	

	protected void selectTableItem(Table table, int selection) {
		table.setFocus();
		table.setSelection(selection);
		table.showSelection();
	}	
	
	protected void enableButtons() {
		int selection = _filtersListViewer.getTable().getSelectionIndex();
		int selectionCount = _filtersListViewer.getTable().getSelectionCount();
	
		_removeButton.setEnabled(_fi.size() > 0 && selection != -1);
		_editButton.setEnabled(_fi.size() > 0 && selection != -1 && selectionCount == 1);
		
//		_moveUpButton.setEnabled(selection > 0 && selection < _fi.size() && selectionCount == 1);
//		_moveDownButton.setEnabled(selection >= 0 && selection < (_fi.size() - 1) && selectionCount == 1);		
	}	
	
	protected void tableSelect()
	{
		enableButtons();
	}	
	
	protected void okPressed() {
		int selection = _filtersListViewer.getTable().getSelectionIndex();
		
	    _selectedFilterName = (selection >= 0) ? _fi.filter(selection).name() : CommonUIMessages._111;
		
		if (!showNoFilter) addNoFilter();
		_fi.save();
		
		super.okPressed();
	}

	public boolean close() {
		_fi.restore();
		
		return super.close();
	}
	
	public String selectedFilterName()
	{
		return _selectedFilterName;
	}
	
	public void selectedFilterName(String selectedFilterName)
	{
		_selectedFilterName = selectedFilterName;
	}	
	
	protected void setInitialSelection()
	{
		setSelectedFilter(_selectedFilterName);
	}
	
	protected void setSelectedFilter(String name)
	{
		if (name != null)
		{
			for (int i = 0; i < _fi.size(); i++)
			{
				if (name.equals(_fi.filter(i).name()))
				{
					selectTableItem(_filtersListViewer.getTable(), i);
					return;
				}
			}
		}		
	}

	protected void removeNoFilters() {
		for (int i = 0; i < _fi.size(); i++) {
			FilterQueries filter = _fi.filter(i);
			if (CommonUIMessages._111.equals(filter.name())) {
				noFilter  = filter;
				_fi.removeFilter(filter);
			}
		}
	}

	protected void addNoFilter() {
		if (noFilter != null) {
			_fi.addFilter(noFilter);
		}
	}
}
