/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersTabUI.java,v 1.3 2008/03/11 03:56:49 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FiltersTabUI {

	protected FiltersDialog _dialog;
	protected String _errorMessage;
	protected boolean _complete;	
	
	protected abstract String getTabName();
	protected abstract Image getTabImage();

	public abstract Control createControl(Composite parent);
	public abstract void initializeFrom(SimpleSearchQuery filter);
	public abstract SimpleSearchQuery performApply();
	
	public void initializeDialog(FiltersDialog dialog)
	{
		_dialog = dialog;
		_errorMessage = null;
		_complete = true;
	}

	public final void setComplete(boolean complete)
	{
		_complete = complete;
		_dialog.updateErrorCompleteState();
	}
	
	public final boolean getComplete()
	{
		return _complete;
	}
	
	public final void setError(String error)
	{
		_errorMessage = error;
		_dialog.updateErrorCompleteState();
	}
	
	public final String getError()
	{
		return _errorMessage;
	}
	
	public final void noError()
	{
		_errorMessage = null;
		_dialog.updateErrorCompleteState();
	}	
}
