/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterQueries.java,v 1.3 2008/01/24 02:28:51 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.util;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;


public class FilterQueries {
	protected String _type;
	protected String _name;
	protected SimpleSearchQuery _standardQuery;
	protected SimpleSearchQuery _advancedQuery;
	
	public static String STANDARD_TAB_EXT = "ST";
	public static String ADVANCED_TAB_EXT = "AD";
	
	public static String NAME_SEPARATOR = ":";	
	
	public FilterQueries()
	{
	}

	public void type(String type)
	{
		_type = type;
		setQueryNames();
	}
	
	public String type()
	{
		return _type;
	}	
	
	public void name(String name)
	{
		_name = name;
		setQueryNames();
	}
	
	public String name()
	{
		return _name;
	}	

	public void standard(SimpleSearchQuery standardQuery)
	{
		_standardQuery = standardQuery;
		setTypeAndName();
	}
	
	public void advanced(SimpleSearchQuery advancedQuery)
	{
		_advancedQuery = advancedQuery;
		setTypeAndName();
	}
	
	protected void setQueryNames()
	{
		if (_type != null && _name != null && _standardQuery != null)
			_standardQuery.setName(_type + NAME_SEPARATOR + _name + NAME_SEPARATOR + STANDARD_TAB_EXT);
		if (_type != null && _name != null && _advancedQuery != null)
			_advancedQuery.setName(_type + NAME_SEPARATOR + _name + NAME_SEPARATOR + ADVANCED_TAB_EXT);		
	}
	
	protected void setTypeAndName()
	{
		String name = null;
		String type = null;
		
		if (_standardQuery != null)
		{
			name = getBaseName(_standardQuery.getName());
			type = getTypeName(_standardQuery.getName());
		}
		else if (_advancedQuery != null)
		{
			name = getBaseName(_advancedQuery.getName());
			type = getTypeName(_advancedQuery.getName());			
		}
		
		if (name != null)
			name(name);
					
		if (type != null)
			type(type);
		
		if (name == null || type == null)
			setQueryNames();			
	}
	
	public SimpleSearchQuery standard()
	{
		return _standardQuery;
	}
	
	public SimpleSearchQuery advanced()
	{
		return _advancedQuery;
	}	

	protected String getTypeName(String queryName)
	{
		if (queryName != null)
		{		
			int idx = queryName.indexOf(NAME_SEPARATOR);
			
			if (idx >= 0)
			{
				return queryName.substring(0, idx);
			}
		}
		
		return null;
	}		
	
	protected String getBaseName(String queryName)
	{
		if (queryName != null)
		{
			int idx1 = queryName.indexOf(NAME_SEPARATOR);
			int idx2 = queryName.lastIndexOf(NAME_SEPARATOR);		
			
			if (idx1 >= 0 && idx2 >= 0)
			{
				return queryName.substring(idx1+1, idx2);
			}
		}
		
		return null;
	}
	
	public FilterQueries copy()
	{
		FilterQueries result = new FilterQueries();
		result.standard((SimpleSearchQuery)EcoreUtil.copy(standard()));
		result.advanced((SimpleSearchQuery)EcoreUtil.copy(advanced()));
		
		return result;
	}
}
