/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterResourceFileHandler.java,v 1.5 2008/01/24 02:28:50 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class FilterResourceFileHandler {
	protected Resource _resource;
	protected	URI _uri;
	
	protected FilterResourceFileHandler(URI uri)
	{
		_uri = uri;
		load();
	}
	
	public static FilterResourceFileHandler instance(URI uri)
	{
		return new FilterResourceFileHandler(uri);
	}
	
	public void addFilter(FilterQueries fq)
	{
		_resource.getContents().add(fq.standard());
		_resource.getContents().add(fq.advanced());		
	}
	
	public FilterQueries filter(int i)
	{
		FilterQueries fq = new FilterQueries();
		
		fq.standard((SimpleSearchQuery)_resource.getContents().get(i*2));
		fq.advanced((SimpleSearchQuery)_resource.getContents().get(i*2+1));		
		
		return fq;
	}
	
	public int size()
	{
		return _resource.getContents().size() / 2;
	}
	
	public void clear()
	{
		_resource.getContents().clear();
	}
	
	public void removeFilter(FilterQueries fq)
	{
		_resource.getContents().remove(fq.standard());
		_resource.getContents().remove(fq.advanced());		
	}
	
	public FilterQueries filter(String name)
	{
		for (int i = 0; i < size(); i++)
		{
			FilterQueries fq = filter(i);
			if (fq.name().equals(name))
				return fq;
		}
		
		return null;
	}
	
	public Vector filters(final String name) {
		Vector result = new Vector();
		for (int i = 0; i < size(); i++) {
			FilterQueries fq = filter(i);
			if (fq.name().equals(name)) {
				result.add(fq);
			}
		}
		
		return result;
	}
	
	public Object[] toArray()
	{
		Vector filters = new Vector();
		
		for (int i = 0; i < size(); i++)
		{
			filters.addElement(filter(i));
		}
		
		return filters.toArray();
	}
	
	public void save()
	{
		try
		{
	    	if (_resource instanceof XMLResource) {
	    		((XMLResource)_resource).setEncoding("UTF-8");
	    	}
			_resource.save(Collections.EMPTY_MAP);
		} catch (IOException e) {
			CommonPlugin.logError(e);
		}	
	}
	
	public void save(OutputStream oStream,Map resourceMap)
	{
		try
		{
	    	if (_resource instanceof XMLResource) {
	    		((XMLResource)_resource).setEncoding("UTF-8");
	    	}
			_resource.save(oStream,resourceMap);
			
		} catch (IOException e) {
			CommonPlugin.logError(e);
		}	
	}
	
	public void load(InputStream is,Map resourceMap)
	{
		if (_resource == null)
		{
			restoreResource();
		}
		else
		{
			try
			{			
				unload(false);
				_resource.load(is,resourceMap);
			}
			catch (IOException e) {
				CommonPlugin.logError(e);
			}				
		}
	}
	
	public void load()
	{
		if (_resource == null)
		{
			restoreResource();
		}
		else
		{
			try
			{			
				unload(false);
				_resource.load(Collections.EMPTY_MAP);
			}
			catch (IOException e) {
				CommonPlugin.logError(e);
			}				
		}
	}
	
	
	public void unload()
	{
		unload(true);
	}
	
	protected void unload(boolean resetResource)
	{
		if (_resource != null)
		{
			_resource.unload();
			
			if (resetResource)
				_resource = null;
		}
	}	
	
	protected void restoreResource()
	{
		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();		
		
		try 
		{
			_resource = resourceSet.getResource(_uri, true);
		}
		catch (Exception e)
		{
			_resource = null;
		}
		
		if (_resource == null)
		{
			_resource = resourceSet.createResource(_uri);
		}
	}
}

