/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterResourceHandler.java,v 1.3 2008/01/24 02:28:51 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;


public class FilterResourceHandler extends FilterResourceFileHandler {
	protected static String TYPE_DIR = "/filterresources/";
	protected static String TYPE_FILE = ".filtxmi";	
	protected static String FILTERS_FILE_NAME = "filters";
	protected static String DEFAULT_FILTER_KEY_PREFIX = "org.eclipse.hyades.ui.filters.internal.defaultFilters.";	
	
	protected static FilterResourceHandler _instance = null;
	
	//List of cache filter before an instance is created.
	protected static List _filtersToAddOnInstanceLoad = null;
	
	//List of cache preference keys before an instance is created.
	protected static List _keysAddToPreferencesOnInstanceLoad = null;	
	
	protected FilterResourceHandler(URI uri)
	{
		super(uri);
	}
	
	public static FilterResourceHandler instance()
	{
		if (_instance == null)
		{
			_instance = new FilterResourceHandler(createMasterListFileURI());
			
			//flush the cache into preference store and filter file.
			addFiltersOnInstanceLoad(null);
			defaultFiltersAddedForKey(null, true);
		}
		
		return _instance;
	}
	
	public static URI createMasterListFileURI()
	{
		String fileName = CommonPlugin.getDefault().getStateLocation().toString() + TYPE_DIR + FILTERS_FILE_NAME + TYPE_FILE; 
		return URI.createFileURI(fileName);
	}	
	
	public FilterQueries createFilterQueries(String type)
	{
		return createFilterQueries(type, null, null);
	}
	
	public FilterQueries createFilterQueries(String type, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery)
	{
		return createFilterQueries(type, getNewFilterSetName(), standardQuery, advancedQuery);
	}

	public static FilterQueries createFilterQueries(String type, String name, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery)
	{
		FilterQueries fq = new FilterQueries();

		fq.type(type);		
		fq.name(name);	
		
		if (standardQuery != null)
			fq.standard(standardQuery);
		else
			fq.standard(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());			

		if (advancedQuery != null)
			fq.advanced(advancedQuery);
		else
			fq.advanced(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());

		return fq;
	}
	

	protected String getNewFilterSetName()
	{
		String defaultName = CommonUIMessages._110;
		
		int i = 1;
		String name = defaultName;
		while (filter(name) != null)
		{
			name = defaultName + " (" + i + ")";
			i++;
		}
		
		return name;
	}		
	
	public static synchronized void addFiltersOnInstanceLoad(List filters)
	{
		if (_filtersToAddOnInstanceLoad == null)
			_filtersToAddOnInstanceLoad = new ArrayList();
		
		if (filters != null)
			_filtersToAddOnInstanceLoad.addAll(filters);
		
		if (_instance == null)
			return;
		
		for (int i = 0; i < _filtersToAddOnInstanceLoad.size(); i++)
			_instance.addFilter((FilterQueries)_filtersToAddOnInstanceLoad.get(i));

		_instance.save();
		
		_filtersToAddOnInstanceLoad.clear();		
	}
	
	
	public static synchronized boolean isDefaultFiltersAddedForKey(String key)
	{
		// if it's in the preference store, then return the value; else check the cache list.
		if (CommonUIPlugin.getDefault().getPluginPreferences().getBoolean(DEFAULT_FILTER_KEY_PREFIX + key))
		{
			return true;
		}
		else if (_keysAddToPreferencesOnInstanceLoad != null)
		{
			for (int i = 0; i < _keysAddToPreferencesOnInstanceLoad.size(); i++)
			{
				if(key.equals(_keysAddToPreferencesOnInstanceLoad.get(i)))
					return true;
			}
		}
		
		return false;
	}
	
	public static synchronized void defaultFiltersAddedForKey(String key, boolean added)
	{
		if (_keysAddToPreferencesOnInstanceLoad == null)
			_keysAddToPreferencesOnInstanceLoad = new ArrayList();
		
		if (key != null)
		{
			if (added)
				_keysAddToPreferencesOnInstanceLoad.add(DEFAULT_FILTER_KEY_PREFIX + key);
			else
			{
				_keysAddToPreferencesOnInstanceLoad.remove(DEFAULT_FILTER_KEY_PREFIX + key); 
				CommonUIPlugin.getDefault().getPluginPreferences().setValue(DEFAULT_FILTER_KEY_PREFIX + key, false);
				CommonUIPlugin.getDefault().savePluginPreferences();
			}
		}
		
		if (_instance == null)
			return;

		for (int i = 0; i < _keysAddToPreferencesOnInstanceLoad.size(); i++)
			CommonUIPlugin.getDefault().getPluginPreferences().setValue((String)_keysAddToPreferencesOnInstanceLoad.get(i), true);

		CommonUIPlugin.getDefault().savePluginPreferences();		
		
		_keysAddToPreferencesOnInstanceLoad.clear();
	}		
}

