/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterType.java,v 1.2 2008/01/24 02:28:51 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.util;


import java.util.Arrays;
import java.util.Comparator;

import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.jface.resource.ImageDescriptor;

import com.ibm.icu.text.Collator;

public class FilterType implements IFilterType {
	protected String _id;
	protected String _name;
	protected ImageDescriptor _icon;
	protected String _description;
	protected FiltersStandardTabUI _standardTabUI;
	protected IAdvancedTabAttributeSet _advancedTabAttributeSet;
	protected String[] _scope;

	
	public FilterType(
			String id,
			String name,
			ImageDescriptor icon,
			String description,
			FiltersStandardTabUI standardTabUI,
			IAdvancedTabAttributeSet advancedTabAttributeSet,
			String[] scope
			)
	{
		_id = id;
		_name = name;
		_icon = icon;
		_description = description;
		_standardTabUI = standardTabUI;
		_advancedTabAttributeSet = advancedTabAttributeSet;
		_scope = scope;
		
		Arrays.sort(_scope, new Comparator() {
			public int compare(Object a, Object b) {
				String str1 = (String)a;
				String str2 = (String)b;
				
				if (str1 == null)
					str1 = "";//$NON-NLS-1$
				if (str2 == null)
					str2 = "";//$NON-NLS-1$
				
				return Collator.getInstance().compare(str1, str2);				
			}
		});		
	}
	
	public String id()
	{
		return _id;
	}
	
	public String name()
	{
		return _name;
	}	
	
	public ImageDescriptor icon()
	{
		return _icon;
	}

	public String description()
	{
		return _description;
	}	
	
	public FiltersStandardTabUI standardTabUI()
	{
		return _standardTabUI; 
	}
	
	public IAdvancedTabAttributeSet advancedTabAttributeSet()
	{
		return _advancedTabAttributeSet;
	}

	public String[] scope() {
		return _scope;
	}
	
    public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		
		if (obj == null)
			return false;
		
		if (obj instanceof IFilterType)
		{
			return id().equals(((IFilterType)obj).id());
		}
		
		return false;
	}
}
