/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ScopeContainer.java,v 1.5 2008/01/24 02:28:51 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.util.ICommonUIHelper;

public class ScopeContainer {

	protected static ScopeContainer _instance = null;
	
	protected Map _scopeSelectedFilter;
	protected Map _scopeViewers;
	protected Map _viewerSelectedScope;	
	
	protected ScopeContainer()
	{
		_scopeSelectedFilter = new HashMap();
		_scopeViewers = new HashMap();
		_viewerSelectedScope = new HashMap();		
	}
	
	public static ScopeContainer instance()
	{
		if (_instance == null)
			_instance = new ScopeContainer();
		
		return _instance;
	}
	
	public String getSelectedFilterName(String scope)
	{
		return (String)_scopeSelectedFilter.get(scope);
	}
	
	public String[] setSelectedFilterName(String selectedFilterName)
	{
		Vector filters = FilterResourceHandler.instance().filters(selectedFilterName);
		if (filters == null || filters.isEmpty()) {
			return null;
		}			

		ArrayList result = new ArrayList(); 
		for (int i = 0; i < filters.size(); i++) {
			FilterQueries filterQueries = (FilterQueries) filters.get(i);
			IFilterType filterType = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(filterQueries.type());

			String[] scope = filterType.scope();
			for (int j = 0; j < scope.length; j++) {
				setSelectedFilterName(scope[j], selectedFilterName);
			}
			result.addAll(Arrays.asList(scope));
		}
		
		return (String[]) result.toArray(new String[result.size()]);
	}
	
	public void setSelectedFilterName(String scope, String selectedFilterName)
	{
		_scopeSelectedFilter.put(scope, selectedFilterName);
	}	

	public void addFilterViewer(IFilterViewer viewer)
	{
		if (viewer == null)
			return;
		
		String[] scope = viewer.getFilterScope();
		
		if (scope == null)
			return;
		
		for (int i = 0; i < scope.length; i++)
		{
			addFilterViewer(scope[i], viewer);
		}
	}
	
	protected void addFilterViewer(String scope, IFilterViewer viewer)
	{
		Vector viewersV = (Vector)_scopeViewers.get(scope);
		
		if (viewersV == null)
		{
			viewersV = new Vector();
			_scopeViewers.put(scope, viewersV);
		}
		
		if (!vectorContainersObject(viewersV, viewer))
			viewersV.addElement(viewer);
	}
	
	protected boolean vectorContainersObject(Vector v, Object obj)
	{
		for (int i = 0; i < v.size(); i++)
		{
			if (v.elementAt(i) == obj)
				return true;
		}
		
		return false;
	}
	
	public void removeFilterViewer(IFilterViewer viewer)
	{
		if (viewer == null)
			return;
		
		String[] scope = viewer.getFilterScope();
		
		if (scope == null)
			return;
		
		for (int i = 0; i < scope.length; i++)
		{
			removeFilterViewer(scope[i], viewer);
		}		
	}
	
	protected void removeFilterViewer(String scope, IFilterViewer viewer)
	{
		Vector viewersV = (Vector)_scopeViewers.get(scope);
		
		if (viewersV == null)
			return;
		
		viewersV.remove(viewer);
	}	

	public IFilterViewer[] getFilterViewers(String scope)
	{
		Vector viewersV = (Vector)_scopeViewers.get(scope);
		
		if (viewersV == null)
			return new IFilterViewer[0];
		
		IFilterViewer[] viewers = new IFilterViewer[viewersV.size()];
		
		viewersV.toArray(viewers);
		
		return viewers;
	}

	
	public void setSelectedScope(String viewer, String selectedScope)
	{
		_viewerSelectedScope.put(viewer, selectedScope);
	}	

	public String getSelectedScope(String viewer)
	{
		return (String)_viewerSelectedScope.get(viewer);
	}	
	
	public String[] scopes()
	{
		Set scopeKeys = _scopeSelectedFilter.keySet();
		String[] scopes = new String[scopeKeys.size()];
		scopeKeys.toArray(scopes);
		
		return scopes;
	}
	
	public String[] viewers()
	{
		Set viewerKeys = _viewerSelectedScope.keySet();
		String[] viewers = new String[viewerKeys.size()];
		viewerKeys.toArray(viewers);
		
		return viewers;		
	}	
}
