/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractClassLoader.java,v 1.3 2008/01/24 02:29:03 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.internal.classloader;

import java.util.Hashtable;


public abstract class AbstractClassLoader 
extends ClassLoader
{
	protected Hashtable classByClassName;
	protected boolean prepend;
	protected char classNameReplacementChar;

	/**
	 * Constructor for BaseAbstractClassLoader.
	 */
	protected AbstractClassLoader()
	{
		super();
		initialize();
	}

	/**
	 * Constructor for BaseAbstractClassLoader.
	 * @param parent
	 */
	protected AbstractClassLoader(ClassLoader parent)
	{
		super(parent);
		initialize();
	}
	
	protected void initialize()
	{
		prepend = true;
		classByClassName = new Hashtable();
	}
	
	public void setPrepend(boolean prepend)
	{
		this.prepend = prepend;
	}

	public boolean getPrepend()
	{
		return prepend;
	}

	public Class loadClass(String className)
	throws ClassNotFoundException
	{
    	return loadClass(className, true);
	}
	
	public synchronized Class loadClass(String className, boolean resolve)
	throws ClassNotFoundException
	{
    	Class result = (Class)classByClassName.get(className);
    	if(result != null)
        	return result;

		if(prepend)
		{
	    	try
	    	{
	        	result = loadFromExtensions(className);

	    	}
	    	catch(ClassNotFoundException e)
	    	{
			}
			
			if(result == null)
	        	return super.loadClass(className, resolve);
		}
		else
		{
	    	try
	    	{
	        	return super.loadClass(className, resolve);
	    	}
	    	catch(ClassNotFoundException e)
	    	{
			}
	
			result = loadFromExtensions(className);
	    	if(result == null)
	        	throw new ClassFormatError();
		}

    	if(resolve)
    		resolveClass(result);

    	classByClassName.put(className, result);
    	return result;
	}
	
	protected abstract byte[] loadClassBytes(String className);

	protected Class loadFromExtensions(String className)
	throws ClassNotFoundException
	{
		byte[] classBytes = null;
    	classBytes = loadClassBytes(className);
    	if(classBytes == null)
        	throw new ClassNotFoundException("className: " + className);

    	return defineClass(className, classBytes, 0, classBytes.length);
	}

	public void setClassNameReplacementChar(char replacement)
	{
    	classNameReplacementChar = replacement;
	}

	protected String formatClassName(String className)
	{
    	if (classNameReplacementChar == '\u0000')
        	return className.replace('.', '/') + ".class";
    	else
        	return className.replace('.', classNameReplacementChar) + ".class";
    }
}
