/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileClassLoader.java,v 1.3 2008/01/24 02:29:03 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.classloader;

import java.io.FileInputStream;
import java.io.InputStream;

import org.eclipse.hyades.ui.internal.util.FileUtil;

public class FileClassLoader
extends AbstractClassLoader
{
	protected String fileDir;

	/**
	 * Example:
	 * 		class: z:\temp\myClass\test\AClass.class
	 * 		filePrefix = z:\\temp\\myClass
	 * 		className = test.AClass.class
	 */
	public FileClassLoader(String fileDir)
	{
		super();
		this.fileDir = fileDir;
	}

	public FileClassLoader(ClassLoader parent, String fileDir)
	{
		super(parent);
    	this.fileDir = fileDir;
	}
	
	protected String getFileDir()
	{
		return fileDir;
	}
	
	protected byte[] loadFileBytes(String fileName)
	{
		if(fileName == null)
			return null;
			
    	try
    	{
    		InputStream inputStream = null;
    		try
    		{
	        	inputStream = new FileInputStream(fileName);
	        	byte[] result = new byte[inputStream.available()];
	        	inputStream.read(result);
	        	
	        	return result;
    		}
    		finally
    		{
    			if(inputStream != null)
    				inputStream.close();
    		}
    	}
    	catch(Exception e)
    	{
    	}
    	
    	return null;
	}

	protected byte[] loadClassBytes(String className, String fileDir)
	{
		if(className == null)
			return null;
			
    	className = formatClassName(className);
		
		String fileName = null;
		if(fileDir != null)
		{
    		fileName = FileUtil.appendPath(fileDir, className);
		}
    	else
    	{
    		fileName = className;
    	}
    		
    	return loadFileBytes(fileName);   		
	}
	
	protected byte[] loadClassBytes(String className)
	{
		return loadClassBytes(className, fileDir);
	}
}