/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PathEntriesClassLoader.java,v 1.3 2008/01/24 02:29:03 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.classloader;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;

public class PathEntriesClassLoader 
extends FileClassLoader
{
    protected Hashtable entryDataByPathEntry;
    protected Vector directories;

	/**
	 * Examples of pathEntries:
	 * 		z:\test\myFile.zip;x\Dir
	 * 		z:\test\myFile.zip;k:\product\;y:\temp\aJar.jar
	 */
    public PathEntriesClassLoader(String pathEntries)
	{
		super(pathEntries);
		initialize(pathEntries);
	}

    public PathEntriesClassLoader(ClassLoader parent, String pathEntries)
	{
		super(parent, pathEntries);
		initialize(pathEntries);
	}

	protected void initialize(String pathEntries)
	{
		entryDataByPathEntry = new Hashtable();
		directories = new Vector();
		
		if(pathEntries != null)
		{
			String[] auxEntries = StringUtil.tokenizer(pathEntries, File.pathSeparator, false);
			for(int i = 0, maxi = auxEntries.length; i < maxi; i++)
			{
				String entry = auxEntries[i].trim();
				File file = new File(entry);
				if(file.exists() && file.isDirectory())
					directories.add(entry);
				else
					entryDataByPathEntry.putAll(FileUtil.getZipEntryDataByZipEntryName(entry));
			}
		}		
	}
	
    protected byte[] loadClassBytes(String className)
	{
		byte[] ret = (byte[])entryDataByPathEntry.get(formatClassName(className));
		if(ret != null)
			return ret;
		
		for(Iterator i = directories.iterator(); i.hasNext();)
		{
			String dir = (String) i.next();			
			ret = super.loadClassBytes(className, dir);
			if(ret != null)
				return ret;
		}
		
		return null;
	}
}
