/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.context;

import org.eclipse.hyades.ui.provisional.context.IContextHandler;
import org.eclipse.hyades.ui.provisional.context.IContextProvider;


public class ContextHandlerImpl implements IContextHandler {

	protected String id;
	protected IContextProvider contextProvider;
	protected boolean excludeContexts;	
	protected String[] contexts;
	
	public ContextHandlerImpl(String _id, IContextProvider _contextProvider, boolean _excludeContexts, String[] _contexts)
	{
		id = _id;
		contextProvider = _contextProvider;
		excludeContexts = _excludeContexts;
		contexts = _contexts;
	}
	
	public String id() {
		return id;
	}

	public IContextProvider getContextProvider() {
		return contextProvider;
	}

	public boolean excludeContexts()
	{
		return excludeContexts;
	}
	
	public String[] contexts() {
		return contexts;
	}
}
