/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.ui.internal.dbresource;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Properties;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

/**
 * @author slavescu,ewchan,apnan
 */
public abstract class DBResourceSupportUI extends DBResourceSupportUICommon {
	
	protected Button enableDBRS;
	protected Group lrsGroup;
	
	protected PreferencePage preferencePage;
	protected Preferences preferenceStore;
	protected String currentStoreType;
	
	public DBResourceSupportUI(PreferencePage preferencePage, Preferences preferenceStore, String currentStoreType) {		
		this.preferencePage = preferencePage;
		this.preferenceStore = preferenceStore;
		this.currentStoreType = currentStoreType;
	}
	public Control createControl(Composite parent) {
		GridLayout layout;
		GridData data;
		Composite content = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 10;
		content.setLayout(layout);
		content.setLayoutData(GridDataUtil.createFill());
		Label lrsDesc = new Label(content, SWT.WRAP);
		lrsDesc.setText(getDescription());
		data = GridDataUtil.createHorizontalFill();
		data.heightHint = 60;
		data.widthHint = 60;
		lrsDesc.setLayoutData(data);
		enableDBRS = new Button(content, SWT.CHECK);
		enableDBRS.setText(getEnableDBResourceLabel());
		lrsGroup = new Group(content, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		lrsGroup.setLayout(layout);
		lrsGroup.setLayoutData(GridDataUtil.createHorizontalFill());
		
		super.populateGroupControl(lrsGroup);

		jdbcTestConnection = new Button(lrsGroup, SWT.NULL);
		jdbcTestConnection.setText(CommonUIMessages._56);

		Label lrsNote = new Label(content, SWT.WRAP);
		lrsNote.setText(getNote());
//		lrsNote.setLayoutData(GridDataUtil.createHorizontalFill());
		data = GridDataUtil.createHorizontalFill();
		data.heightHint = 60;
		data.widthHint = 60;
		lrsNote.setLayoutData(data);
		enableDBRS.addSelectionListener(this);
		jdbcTestConnection.addSelectionListener(this);
//		jdbcBrowse.addSelectionListener(this);
//		jdbcLocation.addModifyListener(this);
//		location.addModifyListener(this);
//		username.addModifyListener(this);
//		password.addModifyListener(this);
				
		initializeValues(false);
		enableGroup(enableDBRS.getSelection());
		validateUserInput(true);
		return content;
	}
	public void initializeValues(boolean defaultValue) {
		
		if (defaultValue) {
			enableDBRS.setSelection(preferenceStore.getDefaultBoolean(LRSPConstants.PREF_ENABLE_LRSP));
			jdbcLocation.setText(preferenceStore.getDefaultString(LRSPConstants.PREF_JDBC_LOCATION));
			isValidJDBCType();
			storeType.setText(preferenceStore.getDefaultString(LRSPConstants.PREF_JDBC_TYPE));
			location.setText(preferenceStore.getDefaultString(LRSPConstants.PREF_JDBC_CONNECTION));
			username.setText(preferenceStore.getDefaultString(LRSPConstants.PREF_JDBC_USERNAME));
			password.setText(LoadersUtils.restorePassword(preferenceStore.getDefaultString(LRSPConstants.PREF_JDBC_PASSWORD)));
		} else {
			enableDBRS.setSelection(preferenceStore.getBoolean(LRSPConstants.PREF_ENABLE_LRSP));
			jdbcLocation.setText(preferenceStore.getString(LRSPConstants.PREF_JDBC_LOCATION));
			isValidJDBCType();
			storeType.setText(preferenceStore.getString(LRSPConstants.PREF_JDBC_TYPE));
			location.setText(preferenceStore.getString(LRSPConstants.PREF_JDBC_CONNECTION));
			username.setText(preferenceStore.getString(LRSPConstants.PREF_JDBC_USERNAME));
			password.setText(LoadersUtils.restorePassword(preferenceStore.getString(LRSPConstants.PREF_JDBC_PASSWORD)));
		}
	}
	public boolean storeValues(){
		Preferences newStore = ModelsHierarchyPlugin.getPlugin().getPluginPreferences();
		String currentResourcePostFix = getResourcePostFix();
		if (enableDBRS.getSelection()) { // &&
			//				!currentStoreTypeName.equals(ACDatabaseUIPlugin.getResourceString("STR_UNKNOWN")) &&
			//				!currentStoreTypeName.equals(ACDatabaseUIPlugin.getResourceString("STR_NONE")) ) {
//			int resKey = getResourceKey();
//			if(!(location.getText().equals(preferenceStore.getString(LRSPConstants.PREF_JDBC_CONNECTION)) && storeType.getText().equals(preferenceStore.getString(LRSPConstants.PREF_JDBC_TYPE)))){
//				resKey = getNextResourceKey();
				String newResourcePostFix = storeType.getText();//+"_"+resKey; 
//				String postfixes = newStore.getString(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE);
//				if(postfixes.indexOf(currentResourcePostFix)>-1){
//					StringUtil.replace(postfixes,currentResourcePostFix,newResourcePostFix);
//					newStore.setValue(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE, postfixes);
//				}else if(postfixes.length()>0){
//					newStore.setValue(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE, ","+newResourcePostFix);
//				}else{
//					newStore.setValue(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE, newResourcePostFix);
//				}
//				preferenceStore.setValue(LRSPConstants.DB_RES_POSTFIX, newResourcePostFix);
//			}

			newStore.setValue(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE, storeType.getText());
					
			currentResourcePostFix = newResourcePostFix;//= getResourcePostFix();

			newStore.setValue(currentResourcePostFix + "/" + "largeResourceSupportJDBCLocation", jdbcLocation.getText());
			newStore.setValue(currentResourcePostFix + "/" + IHyadesResourceExtension.LRSP_LOCATION, location.getText());
			newStore.setValue(currentResourcePostFix + "/" + IHyadesResourceExtension.LRSP_USERNAME, username.getText());
			newStore.setValue(currentResourcePostFix + "/" + IHyadesResourceExtension.LRSP_PASSWORD, LoadersUtils.scramblePassword(password.getText()));
			
			//bugzilla 157641 - The same properties map gets passed to the DB handler, so if any values are changed here 
			//it would change in the instance available with the DB Handler thus currupting it. So ensure that you pass a new
			//properties map
			Properties p = new Properties();
            HyadesResourceExtensions.getInstance().getAllProperties().put(currentResourcePostFix,p);
			p.setProperty("largeResourceSupportJDBCLocation", jdbcLocation.getText());
			p.setProperty("location", location.getText());
			p.setProperty("user", username.getText());
			p.setProperty("password", password.getText());
			p.setProperty("largeResourceSupportStoreType", storeType.getText());
			try {
				p.setProperty("largeResourceSupportJDBCLocation",new File(jdbcLocation.getText()).toURL().toString());
			} catch (MalformedURLException e) {
			}
//			new HyadesResourceRegistryReader().readRegistry();
		} else {
			newStore.setValue(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE, "");
			newStore.setValue(currentResourcePostFix + "/" + "largeResourceSupportJDBCLocation", "");
			
			//bugzilla 157641 - The same properties map gets passed to the DB handler, so if any values are changed here 
            //it would change in the instance available with the DB Handler thus currupting it. So ensure that you pass a new
            //properties map
			Properties p = new Properties();
            HyadesResourceExtensions.getInstance().getAllProperties().put(currentResourcePostFix,p);
			p.setProperty("largeResourceSupportJDBCLocation", "");
			p.setProperty("location", "");
			p.setProperty("user", "");
			p.setProperty("password", "");
			p.setProperty("largeResourceSupportStoreType", "");
		}
		storeUserInput();
		return true;
		
	}

	public void storeUserInput() {		
		preferenceStore.setValue(LRSPConstants.PREF_ENABLE_LRSP, enableDBRS.getSelection());
		preferenceStore.setValue(LRSPConstants.PREF_JDBC_LOCATION, jdbcLocation.getText());
		preferenceStore.setValue(LRSPConstants.PREF_JDBC_TYPE, storeType.getText());
		preferenceStore.setValue(LRSPConstants.PREF_JDBC_CONNECTION, location.getText());
		preferenceStore.setValue(LRSPConstants.PREF_JDBC_USERNAME, username.getText());
		preferenceStore.setValue(LRSPConstants.PREF_JDBC_PASSWORD, LoadersUtils.scramblePassword(password.getText()));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
	    super.widgetSelected(e);
		if (e.widget == enableDBRS) {
			enableGroup(enableDBRS.getSelection());
			String temp = storeType.getText();
			validateUserInput(false);
			if (temp != null)
				storeType.setText(temp);
		}
	}
	
	protected int getResourceKey(){
		Preferences store = CommonUIPlugin.getDefault().getPluginPreferences();		
		return store.getInt(LRSPConstants.DB_RES_KEY);
	}
	
	protected String getResourcePostFix(){
		if(preferenceStore!=null)
			return preferenceStore.getString(LRSPConstants.DB_RES_POSTFIX);
		return "";
	}
	
	protected int getNextResourceKey(){
		Preferences store = CommonUIPlugin.getDefault().getPluginPreferences();
		int key = store.getInt(LRSPConstants.DB_RES_KEY);
		store.setValue(LRSPConstants.DB_RES_KEY,++key);
		return key;
	}
	

	protected void validateUserInput(boolean skipJDBCcheck) {
		setPageComplete(true, null);
		if (enableDBRS.getSelection()) {
			if (!skipJDBCcheck && !isValidJDBCType()) {
			    String jarLocation = jdbcLocation.getText();
				setPageComplete(false, (jarLocation == null || jarLocation.equals(""))?null:CommonUIMessages._64);
			}
			if (jdbcLocation.getText().endsWith(File.separator + "db2jcc.jar")) {
				if (location == null || location.getText().equals(""))
					setPageComplete(false, CommonUIMessages._65);
				else if (username == null || username.getText().equals(""))
					setPageComplete(false, CommonUIMessages._66);
				else if (password == null || password.getText().equals(""))
					setPageComplete(false, CommonUIMessages._67);
				enableJDBCTestConnection();
			}
		}
	}

	protected abstract String getEnableDBResourceLabel();
	
	protected abstract String getNote();
	
	protected abstract String getDescription();

	protected void setPageComplete(boolean complete, String incompleteMsg) {
		if (preferencePage != null) {
			preferencePage.setValid(complete);
			if (!complete && incompleteMsg != null)
				preferencePage.setErrorMessage(incompleteMsg);
			else
				preferencePage.setErrorMessage(null);
		}
	}
}