/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterTypesManager.java,v 1.3 2007/11/27 04:52:11 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.internal.filters;

import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.internal.util.FilterType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

import com.ibm.icu.text.Collator;

public class FilterTypesManager
{
	protected static FilterTypesManager instance;

	protected Map filterTypes;

	protected Map filterScopes;

	protected final String FILTER_TYPES_EXTENTION_POINT = "filterTypes";

	public FilterTypesManager()
	{
		instance=this;
	}

	public static FilterTypesManager instance()
	{
		if(instance==null)
			instance = new FilterTypesManager();
		return instance;
	}

	public IFilterType[] getFilterTypes(String[] scope)
	{
		if (filterTypes == null)
			initialize();

		Vector filterTypesV = new Vector();
		for (int i = 0; i < scope.length; i++)
		{
			Vector filterTypesVi = (Vector) filterScopes.get(scope[i]);

			if (filterTypesVi != null)
			{
				for (int j = 0; j < filterTypesVi.size(); j++)
				{
					if (!filterTypesV.contains(filterTypesVi.elementAt(j)))
						filterTypesV.addElement(filterTypesVi.elementAt(j));
				}
			}
		}

		IFilterType[] iFilterTypes = new IFilterType[filterTypesV.size()];
		filterTypesV.toArray(iFilterTypes);

		return iFilterTypes;
	}

	public IFilterType getFilterType(String id)
	{
		if (filterTypes == null)
			initialize();

		return (IFilterType) filterTypes.get(id);
	}

	protected void initialize()
	{
		filterTypes = new HashMap();
		filterScopes = new HashMap();

		IExtensionPoint commonUIExtPt = Platform.getExtensionRegistry().getExtensionPoint(CommonUIPlugin.PLUGIN_ID, FILTER_TYPES_EXTENTION_POINT);
		IExtensionPoint hyadesUIExtPt = Platform.getExtensionRegistry().getExtensionPoint(CommonUIConstants.HYADES_UI_PLUGIN_ID, FILTER_TYPES_EXTENTION_POINT);

		IConfigurationElement[] commonUIExtPtConf = commonUIExtPt == null ? new IConfigurationElement[0] : commonUIExtPt.getConfigurationElements();
		IConfigurationElement[] hyadesUIExtPtConf = hyadesUIExtPt == null ? new IConfigurationElement[0] : hyadesUIExtPt.getConfigurationElements();

		IConfigurationElement[] elements = new IConfigurationElement[commonUIExtPtConf.length + hyadesUIExtPtConf.length];
		System.arraycopy(commonUIExtPtConf, 0, elements, 0, commonUIExtPtConf.length);
		System.arraycopy(hyadesUIExtPtConf, 0, elements, commonUIExtPtConf.length, hyadesUIExtPtConf.length);

		for (int i = 0; i < elements.length; i++)
		{

			IConfigurationElement elem = elements[i];

			String id = elem.getAttribute("id");
			String name = elem.getAttribute("name");

			if (id == null || name == null)
				continue;

			String iconPath = elem.getAttribute("icon");
			ImageDescriptor icon = null;
			if (iconPath != null)
			{
				try
				{

					URL pluginInstallUrl = Platform.getBundle(elem.getDeclaringExtension().getNamespaceIdentifier()).getEntry("/"); //$NON-NLS-1$									
					icon = ImageDescriptor.createFromURL(new URL(pluginInstallUrl + iconPath));

				} catch (Exception e)
				{
					e.printStackTrace();
				}
			}

			String description = elem.getAttribute("description");

			FiltersStandardTabUI standardTabUI = null;
			IAdvancedTabAttributeSet advancedTabAttributeSet = null;
			try
			{
				if (!("".equals(elem.getAttribute("standardTabUI")) || elem.getAttribute("standardTabUI") == null))
					standardTabUI = (FiltersStandardTabUI) elem.createExecutableExtension("standardTabUI");

				if (!("".equals(elem.getAttribute("advancedAttributes")) || elem.getAttribute("advancedAttributes") == null))
					advancedTabAttributeSet = (IAdvancedTabAttributeSet) elem.createExecutableExtension("advancedAttributes");
			} catch (Exception e)
			{
				e.printStackTrace();
			}

			IConfigurationElement[] appliesToElems = elem.getChildren("appliesTo");

			Vector scopesV = new Vector();
			for (int k = 0; k < appliesToElems.length; k++)
				scopesV.addElement(appliesToElems[k].getAttribute("filterScope"));

			String[] scope = new String[scopesV.size()];
			scopesV.toArray(scope);

			if (standardTabUI != null || advancedTabAttributeSet != null)
			{
				IFilterType filterType = new FilterType(id, name, icon, description, standardTabUI, advancedTabAttributeSet, scope);

				filterTypes.put(filterType.id(), filterType);

				for (int j = 0; j < filterType.scope().length; j++)
				{
					Vector filterTypesV = (Vector) filterScopes.get(filterType.scope()[j]);
					if (filterTypesV != null)
					{
						filterTypesV.addElement(filterType);
					} else
					{
						filterTypesV = new Vector();
						filterTypesV.addElement(filterType);
						filterScopes.put(filterType.scope()[j], filterTypesV);
					}
				}
			}
		}
	}

	public String firstScopeIntersection(String[] scopeSorted, String[] scopeOther)
	{
		for (int i = 0; i < scopeOther.length; i++)
		{
			if (Arrays.binarySearch(scopeSorted, scopeOther[i], new Comparator()
			{
				public int compare(Object a, Object b)
				{
					String str1 = (String) a;
					String str2 = (String) b;

					if (str1 == null)
						str1 = "";//$NON-NLS-1$
					if (str2 == null)
						str2 = "";//$NON-NLS-1$

					return Collator.getInstance().compare(str1, str2);
				}
			}) >= 0)
				return scopeOther[i];
		}

		return null;

	}

	public boolean scopesHaveIntersection(String[] scopeSorted, String[] scopeOther)
	{
		return firstScopeIntersection(scopeSorted, scopeOther) != null;
	}
}
