/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TreeNavigatorFrameSource.java,v 1.2 2008/01/24 02:29:12 apnan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator;


import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;

import com.ibm.icu.text.MessageFormat;

/**
 * Frame source for tree navigators, which uses <code>TreeFrame</code> to capture
 * the state of the tree viewer.
 * 
 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.NavigatorFrameSource} class.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class TreeNavigatorFrameSource 
extends TreeViewerFrameSource
{
	protected ITreeNavigator treeNavigator;

	/**
	 * Constructor for TreeNavigatorFrameSource
	 * @param viewer
	 */
	public TreeNavigatorFrameSource(ITreeNavigator treeNavigator)
	{
		super(treeNavigator.getTreeViewer());
		this.treeNavigator = treeNavigator;
	}
	
	/**
	 * Returns the tree navigator this frame source is associated with.
	 * @return ITreeNavigator
	 */
	protected ITreeNavigator getTreeNavigator()
	{
		return treeNavigator;
	}

	/**
	 * Returns a new frame.  This implementation extends the super implementation
	 * by setting the frame's tool tip text to show the full path for the input
	 * element.
	 * @param input
	 * @return TreeFrame
	 */
	protected TreeFrame createFrame(Object input)
	{
		TreeFrame frame = super.createFrame(input);
		frame.setName(treeNavigator.getFrameName(input));
		frame.setToolTipText(treeNavigator.getFrameToolTipText(input));
		return frame;
	}

	/**
	 * Also updates the navigator's title.
	 * @param TreeFrame
	 */
	protected void frameChanged(TreeFrame frame)
	{
		Object input = frame.getInput();
		if(input instanceof IResource)
		{
			IProject project = ((IResource)input).getProject();
	
			if (project != null && project.isOpen() == false)
			{
				MessageDialog.openInformation(treeNavigator.getViewSite().getShell(), CommonUIMessages._142,
						MessageFormat.format(CommonUIMessages._143, new Object[]{project.getName()}));
				treeNavigator.getFrameList().back();
				return;
			}
		}
		
		super.frameChanged(frame);
		treeNavigator.updateTitle();
	}
}
