/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * An internal API used to add actions to the log navigator view
 * 
 * @author Ali Mehregani
 * @since 4.3
 */
public interface INavigatorContributor
{
	/**
	 * Creates the actions that this contributor will
	 * contribute.
	 */
	public void createActions();
	
	
	/**
	 * Append actions to the menu passed in
	 * 
	 * @param menu The menu that is used to append actions to
	 */
	public void appendActions(IMenuManager menu);


	/**
	 * Invoked for the contributor to update its selection
	 * 
	 * @param selection The selection
	 */
	public void updateSelection(IStructuredSelection selection);
	
	
	/**
	 * Disposes of anything that needs to be destroyed when this
	 * contributor is no longer needed
	 */
	public void dispose();
}
