/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available a
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportDescription.java,v 1.3 2008/01/24 02:29:15 apnan Exp $
 *
 * # %Z% %I% %W% %G% %U% [%H% %T%]
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.report;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.internal.classloader.PathEntriesClassLoader;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;


public class ReportDescription implements IReportDescription
{
	protected String name = null;
	protected String className = null;
	protected String classPath = null;
	protected IReportGenerator reportGenerator = null;
	protected IConfigurationElement configurationElement;
	protected ClassLoader parentClassLoader;
	
	public ReportDescription(ClassLoader parentClassLoader, String name, String className, String classPath) {
		this.name = name;
		this.className = className;
		this.classPath = classPath;
		this.parentClassLoader = parentClassLoader;
	}
	
	public ReportDescription(String name, String className, String classPath, IConfigurationElement configurationElement) {
		this.name = name;
		this.className = className;
		this.classPath = classPath;
		this.configurationElement = configurationElement;
	}

	public String getName() {
		return name;
	}

	public String getClassName() {
		return className;
	}

	public String getClassPath() {
		return classPath;
	}

	public IReportGenerator getReportGenerator() throws Exception
	{
		if (reportGenerator == null)
		{
			if(configurationElement == null)
			{
				String className = getClassName();
				String classPath = getClassPath();
	
				PathEntriesClassLoader classLoader = new PathEntriesClassLoader(parentClassLoader, classPath);
				if (classLoader != null)
				{
					try
					{
						reportGenerator = (IReportGenerator)(classLoader.loadClass(className).newInstance());
					}
					catch(Throwable e)
					{
						CommonPlugin.logError(e);
						return null;	
					}
					
					reportGenerator.setUsedClasspath(classPath);
				}
			}
			else
			{
				try
				{
					reportGenerator = (IReportGenerator)configurationElement.createExecutableExtension("class");
				}
				catch(Throwable e)
				{
					CommonPlugin.logError(e);
					return null;	
				}
			}
		}
		
		return reportGenerator;
	}
	
	public boolean isDefinedByPlugin() {
		return (configurationElement != null);
	}

	/**
	 * @param string
	 */
	public void setClassName(String string) {
		className = string;
		reportGenerator = null;
	}

	/**
	 * @param string
	 */
	public void setClassPath(String string) {
		classPath = string;
		reportGenerator = null;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}
}