/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesReportGeneratorsExtensionRegistryReader.java,v 1.4 2008/01/24 02:28:55 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

/**
 * @author pnedelec
 * 
 */
public class HyadesReportGeneratorsExtensionRegistryReader
{
	public static final String PLUGIN_POINT = "reportGenerators"; //$NON-NLS-1$

	public static final String WIZARD = "wizard"; //$NON-NLS-1$

	public static final String ID = "id"; //$NON-NLS-1$

	public static final String NAME = "name"; //$NON-NLS-1$

	public static final String DESCRIPTION = "description"; //$NON-NLS-1$

	public static final String ICON = "icon"; //$NON-NLS-1$

	protected static HyadesReportGeneratorsExtensionRegistryReader instance = null;

	public static HyadesReportGeneratorsExtensionRegistryReader getInstance()
	{
		if (instance == null)
		{
			instance = new HyadesReportGeneratorsExtensionRegistryReader();
		}
		return instance;
	}

	protected List wizards;

	protected HyadesReportGeneratorsExtensionRegistryReader()
	{
		wizards = new LinkedList();
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint commonUIExtPt = registry.getExtensionPoint(CommonUIPlugin.PLUGIN_ID, PLUGIN_POINT);

		/* Ali M.: For backward compatibility */
		IExtensionPoint hyadesUIExtPt = registry.getExtensionPoint(CommonUIConstants.HYADES_UI_PLUGIN_ID, PLUGIN_POINT);
		IExtension[] commonUIExt = commonUIExtPt == null ? new IExtension[0] : commonUIExtPt.getExtensions();
		IExtension[] hyadesUIExt = hyadesUIExtPt == null ? new IExtension[0] : hyadesUIExtPt.getExtensions();

		IExtension[] extensions = new IExtension[commonUIExt.length + hyadesUIExt.length];
		System.arraycopy(commonUIExt, 0, extensions, 0, commonUIExt.length);
		System.arraycopy(hyadesUIExt, 0, extensions, commonUIExt.length, hyadesUIExt.length);

		try
		{
			for (int i = 0; i < extensions.length; i++)
			{
				IConfigurationElement[] elements = extensions[i].getConfigurationElements();
				for (int j = 0; j < elements.length; j++)
				{
					if (elements[j].getName().equals(WIZARD))
					{
						wizards.add(elements[j]);
					}
				}
			}
		} catch (Exception e)
		{
			CommonPlugin.logError(e);
		}
	}

	public List getWizardCategoryElements()
	{
		return wizards;
	}

}
