/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesReportSelectionWizardPage.java,v 1.7 2009/03/27 17:10:31 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/**
 * <p>Report selection wizard page.</p>
 * 
 * 
 * @author  Patrick Nedelec
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   August 16, 2006
 */
public class HyadesReportSelectionWizardPage extends SelectionPage {
    protected Button openEditorCheckBox;
    protected String contextHelpID = null;

    /**
     * @param pageName
     * @param workbench
     * @param structuredSelection
     * @param wizardElements
     * @param message
     */
    public HyadesReportSelectionWizardPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection, IWizardElement[] wizardElements, String message) {
        super(pageName, workbench, structuredSelection, wizardElements, message);
        setTitle(CommonUIMessages._152); //$NON-NLS-1$
        setDescription("wizard.Report.NoDataPoolDefinition.Page"); //$NON-NLS-1$
        this.contextHelpID=CommonUIPlugin.getID() + ContextIds.NEW_REPORT;
    }
    
    /**
     * @param pageName
     * @param workbench
     * @param structuredSelection
     * @param wizardElements
     * @param message
     * @param contextHelpID
     */
    public HyadesReportSelectionWizardPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection, IWizardElement[] wizardElements, String message, String contextHelpID) {
        this(pageName, workbench, structuredSelection, wizardElements, message);
        this.contextHelpID = contextHelpID;
    }


    protected void addCustomPart(Composite parent) {
        final IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();

        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = layout.marginWidth = 0;
               
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(layout);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));

        openEditorCheckBox = new Button(composite, SWT.CHECK);
        openEditorCheckBox.setText(CommonUIMessages._157); //$NON-NLS-1$
        openEditorCheckBox.setSelection(store.getBoolean("REPORT_OPEN_EDITOR"));     
        openEditorCheckBox.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                store.setValue("REPORT_OPEN_EDITOR", ((Button)e.widget).getSelection());
            }
        });
        
       // WorkbenchHelp.setHelp(composite, UiPlugin.getID() + ContextIds.REPORT_WIZ_PAGE);
       // WorkbenchHelp.setHelp(openEditorCheckBox, UiPlugin.getID() + ContextIds.REPORT_WIZ_EDIT_PAGE);
    }
    
    public boolean openEditor()
    {
        return openEditorCheckBox.getSelection();
    }

    public void performHelp() {
    	// TODO Auto-generated method stub
	   if(contextHelpID != null){
    		PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getContainer().getShell(),contextHelpID);
    		PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
	   }	   
    }

}
