/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: WizardElement.java,v 1.3 2008/01/24 02:29:02 apnan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard.selection;

import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.model.IWorkbenchAdapter;


/**
 * @author marcelop
 * @since 0.2.0
 */
public class WizardElement 
implements IWizardElement, IWizardNode, IDisposable
{
	protected IWizard wizard;
	protected String id;  
	protected String label;
	protected String description;
	protected ImageDescriptor imageDescriptor;
	
	/**
	 * Constructor for WizardElement
	 */
	public WizardElement(IWizard wizard)
	{
		super();
		this.wizard = wizard;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#dispose()
	 */
	public void dispose()
	{
		wizard = null;
		imageDescriptor = null;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#getExtent()
	 */
	public Point getExtent()
	{
		return new Point(-1,-1);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#isContentCreated()
	 */
	public boolean isContentCreated()
	{
		return (getWizard().getPages().length > 0);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement#getWizard()
	 */
	public IWizard getWizard()
	{
		return wizard;
	}

	/**
	 * @param id
	 */
	public void setId(String id)
	{
		this.id = id;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement#getId()
	 */
	public String getId()
	{
		return id;
	}

	/**
	 * @param label
	 */
	public void setLabel(String label)
	{
		this.label = label;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement#getLabel()
	 */
	public String getLabel()
	{
		if(label == null)
			label = wizard.getWindowTitle();
		return label;
	}

	/**
	 * @param description
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * @param imageDescriptor
	 */
	public void setImageDescriptor(ImageDescriptor imageDescriptor)
	{
		this.imageDescriptor = imageDescriptor;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor()
	{
		return imageDescriptor;
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		if(IWorkbenchAdapter.class == adapter)
			return WizardElementWorkbenchAdapter.getInstance();
			
		if(IWizardNode.class == adapter)
			return this;
			
		return null;
	}
}
