/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.provisional.context;

/**
 * This interface has a listing of context attributes.  These attributes are associated
 * with current labels/headers/formats in the views.
 *
 */
public interface IContextAttributes {

	/**
	 * This attribute is associated with the change to package level action in the execution statistics view,
	 * the memory statistics view, and the coverage statistics view.  It is the button that when pressed switches
	 * to the package level.
	 * 
	 * Modes used:
	 * IContextLabelFormatProvider#MODE_VIEW_ACTION
	 * 
	 * Methods used for diplaying labels:
	 * getDisplayStringFromElement
	 * getDisplayImageByElement
	 * getDisplayDescription
	 * getDisplayToolTip
	 */
	public final static String SHOW_PACKAGE_LEVEL = "show.package.level";
	
	/**
	 * This attribute is associated with the change to class level action in the execution statistics view,
	 * the memory statistics view, and the coverage statistics view.  It is the button that when pressed switches
	 * to the class level.
	 * 
	 * Modes used:
	 * IContextLabelFormatProvider#MODE_VIEW_ACTION
	 * 
	 * Methods used for diplaying labels:
	 * getDisplayStringFromElement
	 * getDisplayImageByElement
	 * getDisplayDescription
	 * getDisplayToolTip
	 */
	public final static String SHOW_CLASS_LEVEL = "show.class.level";
	
	/**
	 * This attribute is associated with the change to method level action in the execution statistics view
	 * and the coverage statistics view.  It is the button that when pressed switches to the class level.
	 * 
	 * Modes used:
	 * IContextLabelFormatProvider#MODE_VIEW_ACTION
	 * 
	 * Methods used for diplaying labels:
	 * getDisplayStringFromElement
	 * getDisplayImageByElement
	 * getDisplayDescription
	 * getDisplayToolTip
	 */
	public final static String SHOW_METHOD_LEVEL = "show.method.level";
	
	/**
	 * This attribute is associated with the change to instance level action in the execution statistics view,
	 * and the memory statistics view.  It is the button that when pressed switches to the instance level.
	 * 
	 * Modes used:
	 * IContextLabelFormatProvider#MODE_VIEW_ACTION
	 * 
	 * Methods used for diplaying labels:
	 * getDisplayStringFromElement
	 * getDisplayImageByElement
	 * getDisplayDescription
	 * getDisplayToolTip
	 */
	public final static String SHOW_INSTANCE_LEVEL = "show.instance.level";
	
	/**
	 * This attribute is associated with text displayed in the execution flow view.  The
	 * default java implementation text is "Garbage collected object."
	 * 
	 * Modes used:
	 * IContextLabelFormatProvider#MODE_COLUMN_HEADER
	 * 
	 * Methods used for diplaying labels:
	 * getDisplayStringFromElement
	 */
	public final static String GARBAGE_COLLECTED_OBJECT = "garbage.collected.object";
	
	/**
	 * This attribute is associated with the package name header for the package name column. It
	 * also formats the package name in the column cells, and provides a label for the view filter
	 * dialog, as well as conversion methods for converting the text to and from the model Strings.
	 * 
	 * Modes used:
	 * IContextLabelFormatProvider#MODE_COLUMN_HEADER
	 * IContextLabelFormatProvider#MODE_COLUMN_CONTENT
	 * IContextLabelFormatProvider#MODE_VIEW_FILTER
	 * 
	 * Methods used for diplaying labels:
	 * getDisplayStringFromElement
	 * getDisplayImageByElement
	 * convertModelValueToDisplayString
	 * convertDisplayStringToModelValue 
	 */
	public final static String PACKAGE_NAME = "package.name";
	
	
	public final static String CLASS_NAME = "class.name";
	public final static String METHOD_NAME = "method.name";
	public final static String THREAD_NAME = "thread.name";

	public final static String FT_THREAD_ID = "thread.id";
	
	public final static String PACKAGE_BASE_TIME = "package.base.time";
	public final static String PACKAGE_AVG_BASE_TIME = "package.avg.base.time";
	public final static String PACKAGE_INH_BASE_TIME = "package.inh.base.time";
	public final static String PACKAGE_CUMULATIVE_TIME = "package.cumul.time";
	public final static String PACKAGE_INH_CUMULATIVE_TIME = "package.inh.cumul.time";
	public final static String PACKAGE_CPU_TIME = "package.cpu.time";
	public final static String PACKAGE_CALLS = "package.calls";
	public final static String PACKAGE_INH_CALLS = "package.inh.calls";
	public final static String PACKAGE_TOTAL_INST = "package.total.inst";
	public final static String PACKAGE_LIVE_INST = "package.live.inst";
	public final static String PACKAGE_COLLECTED_INST = "package.collect.inst";
	public final static String PACKAGE_TOTAL_SIZE = "package.total.size";
	public final static String PACKAGE_ACTIVE_SIZE = "package.active.size";
	
	public final static String CLASS_BASE_TIME = "class.base.time";
	public final static String CLASS_AVG_BASE_TIME = "class.avg.base.time";
	public final static String CLASS_INH_BASE_TIME = "class.inh.base.time";
	public final static String CLASS_CUMULATIVE_TIME = "class.cumul.time";
	public final static String CLASS_INH_CUMULATIVE_TIME = "class.inh.cumul.time";
	public final static String CLASS_CPU_TIME = "class.cpu.time";	
	public final static String CLASS_CALLS = "class.calls";
	public final static String CLASS_INH_CALLS = "class.inh.calls";
	public final static String CLASS_TOTAL_INST = "class.total.inst";
	public final static String CLASS_LIVE_INST = "class.live.inst";
	public final static String CLASS_COLLECTED_INST = "class.collect.inst";
	public final static String CLASS_TOTAL_SIZE = "class.total.size";
	public final static String CLASS_ACTIVE_SIZE = "class.active.size";

	public final static String METHOD_BASE_TIME = "method.base.time";
	public final static String METHOD_AVG_BASE_TIME = "method.avg.base.time";
	public final static String METHOD_CUMULATIVE_TIME = "method.cumul.time";
	public final static String METHOD_RAW_CUMULATIVE_TIME = "method.raw.cumul.time";
	public final static String METHOD_CPU_TIME = "method.cpu.time";	
	public final static String METHOD_CALLS = "method.calls";
	public final static String METHOD_START_TIME = "method.start.time";	
	public final static String METHOD_INVOCATIONS = "method.invocations";
	public final static String METHOD_MIN_TIME = "method.min.time";
	public final static String METHOD_MAX_TIME = "method.max.time";
	public final static String METHOD_AVG_TIME = "method.avg.time";
	public final static String METHOD_PERCENT_PER_THREAD = "method.percent.thread";
	public final static String METHOD_QUALIFIED_NAME = "method.qualified.name";

	public final static String COVERAGE_CALLS = "cov.calls";
	public final static String COVERAGE_METHOD_MISSED = "cov.methods.missed";
	public final static String COVERAGE_METHOD_HIT = "cov.methods.hit";
	public final static String COVERAGE_METHOD_PERC_HIT = "cov.perc.methods.hit";
	
	public final static String FT_OBJECT_ID = "ft.object.id";
	
	public final static String OBJECT_NAME = "object.name";

	public final static String OBJECT_CALLS = "object.calls";
	public final static String OBJECT_BASE_TIME = "object.base.time";
	public final static String OBJECT_CUMULATIVE_TIME = "object.cumul.time";
	public final static String OBJECT_CPU_TIME = "object.cpu.time";
	public final static String OBJECT_COLLECTED = "object.collected";
	public final static String OBJECT_SIZE = "object.size";
	public final static String OBJECT_ACTIVE_SIZE = "object.active.size";

	public final static String THREAD_CLASS_NAME = "thread.name.and.class";
	public final static String THREAD_START_TIME = "thread.start.time";
	public final static String THREAD_STOP_TIME = "thread.stop.time";
	public final static String THREAD_STATE = "thread.state";
	public final static String THREAD_RUNNING_TIME = "thread.running.time";
	public final static String THREAD_SLEEPING_TIME = "thread.sleeping.time";
	public final static String THREAD_WAITING_TIME = "thread.waiting.time";
	public final static String THREAD_BLOCKED_TIME = "thread.blocked.time";
	public final static String THREAD_DEADLOCKED_TIME = "thread.deadlocked.time";
	public final static String THREAD_BLOCK_COUNT = "thread.block.count";
	public final static String THREAD_DEADLOCK_COUNT = "thread.deadlock.count";
	
	public final static String REF_SIZE = "ref.size";
	public final static String REF_NUMBER_TO = "ref.number.to";
	public final static String REF_NUMBER_BY = "ref.number.by";
	public final static String REF_DETAILS_BY = "ref.details.by";
	public final static String REF_DETAILS_TO = "ref.details.to";

	public final static String FT_AGENT_NAME = "ft.agent.name";	
	
	public final static String FT_TOP_BASE_TIME = "ft.top.base.time";
	public final static String FT_TOP_CUMULATIVE_TIME = "ft.top.cumul.time";
	public final static String FT_TOP_CALLS = "ft.top.calls";
	public final static String FT_TOP_TOTAL_SIZE = "ft.top.total.size";
	public final static String FT_TOP_COLLECTED_SIZE = "ft.top.collect.size";	
	public final static String FT_TOP_TOTAL_INST = "ft.top.total.inst";
	public final static String FT_TOP_COLLECTED_INST = "ft.top.collect.inst";
}

