/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.provisional.context;


public interface IContextHandler {

	/**
	 * Returns the ID for the context handler.
	 * @return
	 */
	public String id();
	
	/**
	 * Returns the context provider associated with this context handler.
	 * @return IContextProvider an instance of this provider
	 */
	public IContextProvider getContextProvider();
	
	/**
	 * Returns false if the contexts returned in the contexts() method should
	 * be the contexts associated with this IContextHandler.  Returns true if this
	 * IContextHandler should be associated with all contexts except the ones
	 * in the listing.
	 * @return boolean
	 */
	public boolean excludeContexts();
	
	/**
	 * Returns a context listing for this IContextHandler.  If excludeContexts() returns
	 * true, then this listing is excluded or not associated with this IContextHandler.  If
	 * excludeContents() returns false, then this context listing is associated with the 
	 * IContextHandler. 
	 * @return String[] the context listing
	 */
	public String[] contexts();
}
