 /********************************************************************** 
 * Copyright (c) 2005, 2006  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: IContextLanguage.java,v 1.1 2006/08/16 21:15:24 amehregani Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.ui.provisional.context;

import org.eclipse.jface.resource.ImageDescriptor;

public interface IContextLanguage {

	/**
	 * The id associated with this context language.
	 * @return String
	 */
	public String id();
	
	/**
	 * Returns the context key associated with this context language.  This key will be used
	 * to lookup this context.
	 * @return String
	 */
	public String contextKey();
	
	/**
	 * Returns the name of this context.
	 * @return String
	 */
	public String name();
	
	/**
	 * Returns the description for this context.
	 * @return String
	 */
	public String description();
	
	/**
	 * Returns the String for the icon for this context.
	 * @return String
	 */
	public ImageDescriptor icon();
}
