/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.provisional.context;


public interface IContextOpenSourceHandler {

	/**
	 * Returns the ID for the context open source handler.
	 * @return
	 */
	public String id();
	
	/**
	 * Returns the context open source provider associated with this context handler.
	 * @return IContextOpenSourceProvider an instance of this provider
	 */
	public IContextOpenSourceProvider getContextOpenSourceProvider();
	
	/**
	 * Returns false if the contexts returned in the contexts() method should
	 * be the contexts associated with this IContextOpenSourceHandler.  Returns true if this
	 * IContextOpenSourceHandler should be associated with all contexts except the ones
	 * in the listing.
	 * @return boolean
	 */
	public boolean excludeContexts();
	
	/**
	 * Returns a context listing for this IContextOpenSourceHandler.  If excludeContexts() returns
	 * true, then this listing is excluded or not associated with this IContextOpenSourceHandler.  If
	 * excludeContents() returns false, then this context listing is associated with the 
	 * IContextOpenSourceHandler. 
	 * @return String[] the context listing
	 */
	public String[] contexts();
}
