/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IContextOpenSourceProvider.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.provisional.context;

import org.eclipse.emf.ecore.EObject;

/**
 * Extends <code>IContextOpenSourceProvider</code> with the methods
 * to provide service on open source of a given element. 
 * Used by most TPTP viewers (e.g. Execution Statistic View) on open source
 * action on view elements.
 */
public interface IContextOpenSourceProvider {
	
	/**
	 * Return the UI name of the context open source provider
	 * @return a string display name of the context open source provider
	 */
	public String getName();
	
	/**
	 * Perform open source action of the given element, with respect to the given
     * context language.
     *
	 * @param context language context of the given selection
	 * @param selection object to be open source on
	 * @return false indicates falure in open source action and and error message
	 * 			will prompt to user about failure in open source action, true if success
	 */
	public boolean openSource(String context, EObject selection);

}
