/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IContextProvider.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.provisional.context;


public interface IContextProvider {
	
	/**
	 * Return the UI name of the context provider
	 * @return a string display name of the context provider
	 */
	public String getName();
	
	/**
	 * Return a short description of the context provider
	 * @return a string short description of the context provider
	 */
	public String getDescription();
		
	/**
	 * Return an array of attributes support by this provider
	 * @return String[] array of support attributes by this context provider
	 */
	public String[] getSupportAttributes();
	
	/**
	 * Retrieve label provider of context sensitive element such as action name
	 * or column header name
	 * @param attributeID attribute id of visual component 
	 * @return IFilterAttributeLabelProvider provider for conext sensitive labeling, null if none exists
	 */
	public IContextLabelFormatProvider getContextLabelFormatProvider(String key);
	
	/**
	 * Retrieve the base provider ID of this provider. Base provider is looked up
	 * for information that is not support in this provider.
	 *  
	 * @return parent provider ID
	 */
	public String getBaseProvider();
	
}
