/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CustomContentProvider.java,v 1.2 2010/02/26 19:20:02 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.provisional.extension;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

/**
 * A utility class for the pdCustomContentProvider extension point.
 *
 */
public class CustomContentProvider {

	/**
	 * The ID of the extension point.
	 */
	private final static String PD_CUSTOM_CONTENT_PROVIDER_EXT_ID = CommonUIPlugin.getID()	+ ".pdCustomContentProvider"; //$NON-NLS-1$

	/**
	 * Provides access to the contributors for the pdCustomContentProvider extension point.
	 * @return The registered plug-ins that use the extension point.
	 */
	public static ICustomContentProvider[] getContributors() {
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PD_CUSTOM_CONTENT_PROVIDER_EXT_ID);
		List providers = new ArrayList();
		try {
			if(elements != null) {
				for (int configElement = 0; configElement < elements.length; configElement++) {
					ICustomContentProvider provider = (ICustomContentProvider) elements[configElement].createExecutableExtension("class"); //$NON-NLS-1$
					if(provider != null)
						providers.add(provider);
				}
			}
		} catch (CoreException e) {
			CommonPlugin.logError(e);
		}
		
		// Output the provider list to an array in order to return the result.
		ICustomContentProvider[] providerArray = new ICustomContentProvider[providers.size()];
		for(int i = 0; i < providers.size(); i++)
			providerArray[i] = (ICustomContentProvider)providers.get(i);
		return providerArray;
	}

}
