/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ICustomContentProvider.java,v 1.1 2010/01/19 16:05:23 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.provisional.extension;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.ui.extension.INavigatorItem;

/**
 * An interface for defining custom content providers of INavigatorItem to be displayed in the view. 
 * For example, the Profiling and Logging perspective navigator. This interface is used by 
 * the pdCustomContentProvider extension point.
 *
 */
public interface ICustomContentProvider {

	/**
	 * Checks if the <code>org.eclipse.core.resources.IResource</code> is a valid resource to be displayed
	 * in the view.
	 * @param res The resource to validate.
	 * @return true if the resource should be displayed, false otherwise.
	 */
	public boolean isValidResource(IResource res); 
	/**
	 * Converts the <code>org.eclipse.core.resources.IResource</code> to an 
	 * <code>org.eclipse.hyades.ui.extension.INavigatorItem</code> for displaying in the view.
	 * @param res The resource to convert.
	 * @return The <code>org.eclipse.hyades.ui.extension.INavigatorItem</code> for the resource.
	 */
	public INavigatorItem getContribution(IResource res);
}
