/********************************************************************** 
 * Copyright (c) 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.ui.provisional.navigator.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

/**
 * An interface for extension point 
 * <code>org.eclipse.tptp.platform.common.ui.NavigatorActions</code>
 * for contributing context menu action in navigator views.
 * 
 * @author Eugene Chan
 * @since 4.4
 *
 */
public interface INavigatorActionContributor {

	/**
	 * Creates the actions that this contributor will contribute.
	 * 
	 * @return IAction action class to be contributed in context menu group
	 */
	public IWorkbenchAction createAction();
	

	/**
	 * Set visibility of action based on view selection.
	 * 
	 * @param selection user selection in view.
	 * @return boolean true to make action visible, 
	 * 				   false to make action not visible, that is to not contribute action to the context menu group.
	 */
	public boolean isVisible(IStructuredSelection selection);

	/**
	 * Disposes of anything that needs to be destroyed when this
	 * contributor is no longer needed
	 */
	public void dispose();
}
