/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportGeneratorWizard.java,v 1.3 2008/01/24 02:29:14 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.report;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

/**
 * This class is the base class for the reportGenerators extension.
 * 
 * @author pnedelec
 * @since 4.0.0
 *
 */
public abstract class ReportGeneratorWizard extends HyadesWizard implements IWizardNode {
    //- A flag to indicate if the pages contents have already been created
    protected boolean contentCreated;
    protected String id;
    
    /**
     * Constructor
     */
    public ReportGeneratorWizard() {
        super();
        setNeedsProgressMonitor(true);
        this.contentCreated = false;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#addPages()
     */
    public void addPages() {
        try {
            addReportPages();
            contentCreated = true;
        } catch (Exception e) {
            CommonPlugin.logError(e);
            String error = e.getLocalizedMessage();
            if ((error == null) || (error.length() == 0)) error = e.getMessage();
            if ((error == null) || (error.length() == 0)) error = e.getClass().getName();
            MessageDialog.openError(getShell(), CommonUIMessages._8, NLS.bind(CommonUIMessages._47, error)); 
        }
    }

    /**
     * Adds pages to the wizard, the contents of the wizard is created. 
     * This method is called only one time for an instance of wizard.
     * @throws Exception
     *  
     */
    abstract protected void addReportPages() throws Exception;

    /**
     * The performFinish() method will be called by the wizard that contains this wizard.
     * 
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    public boolean performFinish() {
        return true;
    }
    
    /**
     * Returns the editor ID to determine the editor to show the generated report.
     */
    public String getEditorId(){
    	return null;
    }
  
    /**
     * Generate the report. This method is called in the performFinish() method of the parent ReportWizard wizard.
     * @param monitor
     *            that will display a progress bar during the generation.
     * @return the generated report file. For example an index file.
     * @throws Exception
     */
    abstract public IFile generate(IProgressMonitor monitor) throws Exception;

    /**
     * @see org.eclipse.jface.wizard.IWizardNode#getExtent()
     */
    public Point getExtent() {
        return null;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizardNode#getWizard()
     */
    public IWizard getWizard() {
        return this;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizardNode#isContentCreated()
     */
    public boolean isContentCreated() {
        return contentCreated;
    }

    /**
     * Return true if the wizard is available for the workbench selection.
     */
    public abstract boolean isAvailable(ISelection selection);

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
 
}
