/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonUIHelper.java,v 1.3 2008/02/28 03:11:58 jkubasta Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/
package org.eclipse.hyades.ui.util;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
/**
 * 
 * @author slavescu
 *
 */
public class CommonUIHelper implements ICommonUIHelper {

	public FilterTypesManager getFilterTypesManager() {
		return FilterTypesManager.instance();
	}
	public BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String value, boolean caseInsensitive)
	{
		String [] values = new String[1];
		values[0] = value;
	
		return createBinaryExpression(feature, operator, values, caseInsensitive);
	}

	public BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String[] values, boolean caseInsensitive)
	{
		BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression(); 
		
		SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		leftOperand.setFeature(feature);
	
		binaryExpression.setLeftOperand(leftOperand);
		
		binaryExpression.setOperator(operator);
	
		for (int i = 0; i < values.length; i++)
		{
			SimpleOperand rightOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
	
			if (feature instanceof EAttribute)
				rightOperand.setValueType(((EAttribute)feature).getEAttributeType());
	
			rightOperand.setValue(values[i]);		
	
			binaryExpression.getRightOperands().add(rightOperand);
		}
	
		binaryExpression.setCaseInsensitive(caseInsensitive);
		
		return binaryExpression;
	}
	
	public LoadersManager createLoadersManager() {
		return new LoadersManager();
	}

}
