/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ICommonUIHelper.java,v 1.3 2008/01/31 03:27:02 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/
package org.eclipse.hyades.ui.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.tptp.platform.extensions.IApplicationManager;

/**
 * Interface defining common ui utilities.
 * 
 * @author slavescu
 *
 */
public interface ICommonUIHelper {

	/**
	 * Common UI Helper component id.
	 */
	public static final String TPTP_COMMON_UI_HELPER = "TPTP/COMMON/CommonUIHelper";
	
	public ICommonUIHelper INSTANCE = (ICommonUIHelper)IApplicationManager.INSTANCE.createDefaultHandlerInstance(TPTP_COMMON_UI_HELPER);

	public FilterTypesManager getFilterTypesManager();

	public BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String value, boolean caseInsensitive);

	public BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String[] values, boolean caseInsensitive);

	public LoadersManager createLoadersManager();

}
