/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDisposable.java,v 1.2 2006/09/20 19:49:13 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

/**
 * Interface for objects that have resources to be free up when they are
 * not required.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public interface IDisposable
{
	/**
	 * Disposes any resource used by this object. There are no guarantees that 
	 * this method is invoked by this object's container or by the Hyades framework.
	 */
	public void dispose();
}
