/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: INamedElement.java,v 1.2 2006/09/20 19:49:13 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

import org.eclipse.core.runtime.IAdaptable;

/**
 * Interface to define elements with name and description features.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public interface INamedElement
extends IAdaptable
{
	/**
	 * Returns this instance's name.
	 * @return String
	 */
	public String getName();

	/**
	 * Sets this instance's name.
	 * @param name
	 */
	public void setName(String name);

	/**
	 * Returns this instance's description.
	 * @return String
	 */	
	public String getDescription();
	
	/**
	 * Sets this instance's description.
	 * @param description
	 */
	public void setDescription(String description);
}
