/********************************************************************** 
 * Copyright (c) 2005, 2008  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: PrintSDViewReportPage.java,v 1.3 2008/01/24 02:29:13 apnan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.uml2sd.internal.reports;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDPrintDialogUI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * 
 *
 */
public class PrintSDViewReportPage extends WizardPage {

	protected SDView view;
	protected SDPrintDialogUI dialogUI;
	
	public PrintSDViewReportPage(String name, SDView sdview)
	{
		super(name);
		
		view = sdview;
	}
	
	public void createControl(Composite parent) {
		
		dialogUI = new SDPrintDialogUI(getShell(), view.getSDWidget(), true);	
		dialogUI.setParentWizardPage(this);

        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        composite.setLayout(layout);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		setControl(dialogUI.createDialogArea(composite));

	}
	
	public void performFinish()
	{
		if(dialogUI.okPressed())
		{
			view.getSDWidget().printUI(dialogUI);
		}
		
		
	}

}
