/* ***********************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PrintSDViewReportWizard.java,v 1.3 2007/12/06 03:17:57 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/
package org.eclipse.hyades.uml2sd.internal.reports;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 *
 */
public class PrintSDViewReportWizard extends ReportGeneratorWizard {
		
    protected PrintSDViewReportPage reportPage;
	
	public PrintSDViewReportWizard() {
		super();
        setWindowTitle(SDMessages._122); //$NON-NLS-1$
	}

	public boolean isAvailable(ISelection selection) {
		
		if(selection == null || selection.isEmpty())
			return false;
		
		Object sel = ((StructuredSelection)selection).getFirstElement();
						
		return (sel instanceof SDView);
	}
	
    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
    	
    	Object sel = getSelection().getFirstElement();
    	if(sel == null || !(sel instanceof SDView))
    		return;
    	
        reportPage = new PrintSDViewReportPage("page1", (SDView)sel); //$NON-NLS-1$
        reportPage.setTitle(SDMessages._120); //$NON-NLS-1$
        reportPage.setDescription(SDMessages._121); //$NON-NLS-1$        
    }

    /**
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#generate(org.eclipse.core.runtime.IProgressMonitor)
     */
    public IFile generate(IProgressMonitor monitor) throws Exception {
    	
    	Object sel = getSelection().getFirstElement();
    	if(sel == null || !(sel instanceof SDView))
    		return null;
      
        monitor.beginTask("", 4); //$NON-NLS-1$             
    	
        monitor.worked(1);
        print((SDView)sel);
        monitor.worked(1);

         monitor.done();
           
        return null;
    }
	
	/**
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#addReportPages()
     */
    protected void addReportPages() throws Exception {
        addPage(reportPage);
    }

    /**
     * 
     * @param viewer
     * @return
     */
	protected boolean print(SDView view) {
		
		if (view == null)
			return false;
		if (view.getSDWidget()==null)
			return false;
		reportPage.performFinish();
		
		return true;
	}    
	
}
