/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterInternalMessages.java,v 1.3 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class FilterInternalMessages extends Action {

	protected SDView view = null;
	
	public FilterInternalMessages(SDView theView)
	{
		super(SDMessages._45,AS_CHECK_BOX); 
		view = theView;
		setToolTipText(SDMessages._46); 
		setId("org.eclipse.hyades.uml2sd.ui.filterinternalmesssage"); //$NON-NLS-1$
		setImageDescriptor(SDUtil.getResourceImage("full/clcl16/filters.gif")); //$NON-NLS-1$
	}
	
	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getInternalMessageFilterProvider()!= null)
			view.getInternalMessageFilterProvider().setInternalMessageFiltered(isChecked());
		//view.getSDWidget().redraw();
	}
}
