/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveSDLeft.java,v 1.2 2006/09/20 20:56:26 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;


import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 */
public class MoveSDLeft extends Action{

	protected SDWidget viewer = null;
	protected SDView view = null;
	
	public MoveSDLeft (IViewPart _view)
	{
		super();
		view = (SDView)_view;
		if (view instanceof SDView)
			viewer = ((SDView)view).getSDWidget();
	}

	public void run ()
	{
		if (viewer!=null)
			viewer.scrollBy( -viewer.getVisibleWidth(), 0 );
	}
}
