/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NextPage.java,v 1.3 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;

/**
 * @author sveyrier
 *
 */
public class NextPage extends Action{
	
	protected SDView view = null;
	
	public NextPage(SDView theView)
	{
		super();
		view = theView;
		setText(SDMessages._36); 
		setToolTipText(SDMessages._38); 
		setId("org.eclipse.hyades.uml2sd.ui.nextpage"); //$NON-NLS-1$
		setImageDescriptor(CommonUIImages.INSTANCE.getImageDescriptor("c", CommonUIImages.IMG_UI_NEXT_PAGE)); //$NON-NLS-1$
	}

	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getSDPagingProvider()!=null)
			view.getSDPagingProvider().nextPage();
		view.updateCoolBar();
		view.getSDWidget().redraw();
	}
}
