/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSDFiltersDialog.java,v 1.3 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterListDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.jface.action.Action;

/**
 * Action delegate for 'Filter' on a message
 */
public class OpenSDFiltersDialog extends Action {

	protected SDView view;	
	protected ISDFilterProvider provider;

	/**
	 * @param view_
	 */
	public OpenSDFiltersDialog(SDView view_, ISDFilterProvider provider_) {
		super(SDMessages._43);
		setImageDescriptor(SDUtil.getResourceImage("full/clcl16/filters.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdFilters"); //$NON-NLS-1$
		setToolTipText(SDMessages._43);
		view = view_;
		provider = provider_;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (view == null) {
			return;
		}
		FilterListDialog dialog = new FilterListDialog(view, provider);
		dialog.open();
	}
}
