/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSDFindDialog.java,v 1.3 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;

/**
 * @author sveyrier
 *
 */
public class OpenSDFindDialog extends Action{
	
	protected SDView view = null;
	
	public OpenSDFindDialog(SDView theView)
	{
		super(SDMessages._41);
		setImageDescriptor(SDUtil.getResourceImage("full/clcl16/search_seqdiag_menu.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdFind"); //$NON-NLS-1$
		setToolTipText(SDMessages._41);
		view = theView;
	}

	public void run()
	{
		if (view == null)
			return;
		if ((view.getExtendedFindProvider()!=null)&&(view.getExtendedFindProvider().getFindAction()!=null))
		{
			view.getExtendedFindProvider().getFindAction().run();
		}
		else if (view.getSDFindProvider()!=null)
		{
			SearchFilterDialog dialog = new SearchFilterDialog(view, view.getSDFindProvider(), false, SWT.NORMAL);
			dialog.open();
		}
	}
}
