/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSDPagesDialog.java,v 1.4 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.PagesDialog;
import org.eclipse.hyades.uml2sd.ui.internal.SDImages;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.action.Action;

/**
 * Action delegate for 'Filter' on a message
 */
public class OpenSDPagesDialog extends Action {

	public static final String ACTIONID_SDPAGING = "org.eclipse.hyades.uml2sd.ui.sdPaging"; //$NON-NLS-1$
	protected SDView view;	
	protected ISDAdvancedPagingProvider provider;

	/**
	 * @param view_
	 */
	public OpenSDPagesDialog(SDView view_, ISDAdvancedPagingProvider provider_) {
		super(SDMessages._44);
		setImageDescriptor(SDImages.INSTANCE.getImageDescriptor("c", SDImages.GOTO_PAGE)); 
		setId(ACTIONID_SDPAGING);
		view = view_;
		provider = provider_;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (view == null) {
			return;
		}
		PagesDialog dialog = new PagesDialog(view, provider);
		dialog.open();
	}
}
