/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PrevPage.java,v 1.3 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;

/**
 * @author sveyrier
 *
 */
public class PrevPage extends Action{
	
	protected SDView view = null;
	
	public PrevPage(SDView theView)
	{
		super();
		view = theView;
		setText(SDMessages._35); 
		setToolTipText(SDMessages._37); 
		setId("org.eclipse.hyades.uml2sd.ui.prevpage"); //$NON-NLS-1$
		setImageDescriptor(CommonUIImages.INSTANCE.getImageDescriptor("c", CommonUIImages.IMG_UI_PREV_PAGE)); //$NON-NLS-1$
	}

	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getSDPagingProvider()!=null)
			view.getSDPagingProvider().prevPage();
		view.updateCoolBar();
		view.getSDWidget().redraw();
	}
}
